/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.skill;

import com.google.common.collect.ImmutableList;
import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.SkillProvider;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.common.message.MessageProvider;
import dev.aurelium.auraskills.common.registry.OptionSupplier;
import dev.aurelium.auraskills.common.skill.LoadedSkill;
import dev.aurelium.auraskills.common.skill.SkillManager;
import dev.aurelium.auraskills.common.util.data.OptionProvider;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkillSupplier
extends OptionSupplier<Skill>
implements SkillProvider {
    private final SkillManager skillManager;
    private final MessageProvider messageProvider;

    public SkillSupplier(SkillManager skillManager, MessageProvider messageProvider) {
        this.skillManager = skillManager;
        this.messageProvider = messageProvider;
    }

    private LoadedSkill get(Skill skill) {
        return this.skillManager.getSkill(skill);
    }

    @Override
    public boolean isEnabled(Skill skill) {
        if (!this.skillManager.isLoaded(skill)) {
            return false;
        }
        return this.get(skill).options().enabled();
    }

    @NotNull
    public ImmutableList<Ability> getAbilities(Skill skill) {
        return this.get(skill).abilities();
    }

    @Override
    @Nullable
    public ManaAbility getManaAbility(Skill skill) {
        return this.get(skill).manaAbility();
    }

    @NotNull
    public ImmutableList<XpSource> getSources(Skill skill) {
        return this.get(skill).sources();
    }

    @Override
    public int getMaxLevel(Skill skill) {
        return this.get(skill).options().maxLevel();
    }

    @Override
    public String getDisplayName(Skill skill, Locale locale, boolean formatted) {
        return this.messageProvider.getSkillDisplayName(skill, locale, formatted);
    }

    @Override
    public String getDescription(Skill skill, Locale locale, boolean formatted) {
        return this.messageProvider.getSkillDescription(skill, locale, formatted);
    }

    @Override
    public OptionProvider getOptions(Skill type) {
        return this.get(type).options();
    }

    @Override
    public boolean isLoaded(Skill type) {
        return this.skillManager.isLoaded(type);
    }
}

