/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.scheduler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.scheduler.ScheduledTask;
import dev.aurelium.auraskills.common.scheduler.SubmittedTask;
import dev.aurelium.auraskills.common.scheduler.Task;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class Scheduler {
    private final AuraSkillsPlugin plugin;
    private final ExecutorService asyncExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("auraskills-async-task-%d").build());
    private final ScheduledExecutorService asyncScheduler = Executors.newScheduledThreadPool(0, new ThreadFactoryBuilder().setNameFormat("auraskills-async-scheduler-%d").build());

    public Scheduler(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
    }

    public abstract Task executeSync(Runnable var1);

    public Task executeAsync(Runnable runnable) {
        return new SubmittedTask(this.asyncExecutor.submit(runnable));
    }

    public abstract Task scheduleSync(Runnable var1, long var2, TimeUnit var4);

    public Task scheduleAsync(Runnable runnable, long delay, TimeUnit timeUnit) {
        return new ScheduledTask(this.asyncScheduler.schedule(runnable, delay, timeUnit));
    }

    public abstract Task timerSync(TaskRunnable var1, long var2, long var4, TimeUnit var6);

    public abstract Task timerAsync(TaskRunnable var1, long var2, long var4, TimeUnit var6);

    public void shutdown() {
        this.asyncExecutor.shutdown();
        this.asyncScheduler.shutdown();
        try {
            boolean asyncExecutorDone = this.asyncExecutor.awaitTermination(2L, TimeUnit.SECONDS);
            boolean asyncSchedulerDone = this.asyncScheduler.awaitTermination(2L, TimeUnit.SECONDS);
            if (!asyncExecutorDone || !asyncSchedulerDone) {
                this.plugin.logger().warn("Scheduler had incomplete tasks when shutting down");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

