/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.registry;

import dev.aurelium.auraskills.api.option.OptionedProvider;
import dev.aurelium.auraskills.common.util.data.OptionProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class OptionSupplier<T>
implements OptionedProvider<T> {
    public abstract OptionProvider getOptions(T var1);

    public abstract boolean isLoaded(T var1);

    @Override
    public boolean optionBoolean(T type, String key) {
        return this.getOptions(type).getBoolean(key);
    }

    @Override
    public boolean optionBoolean(T type, String key, boolean def) {
        return this.isLoaded(type) ? this.getOptions(type).getBoolean(key, def) : def;
    }

    @Override
    public int optionInt(T type, String key) {
        return this.getOptions(type).getInt(key);
    }

    @Override
    public int optionInt(T type, String key, int def) {
        return this.isLoaded(type) ? this.getOptions(type).getInt(key, def) : def;
    }

    @Override
    public double optionDouble(T type, String key) {
        return this.getOptions(type).getDouble(key);
    }

    @Override
    public double optionDouble(T type, String key, double def) {
        return this.isLoaded(type) ? this.getOptions(type).getDouble(key, def) : def;
    }

    @Override
    public String optionString(T type, String key) {
        return this.getOptions(type).getString(key);
    }

    @Override
    public String optionString(T type, String key, String def) {
        return this.isLoaded(type) ? this.getOptions(type).getString(key, def) : def;
    }

    @Override
    public List<String> optionStringList(T type, String key) {
        return this.isLoaded(type) ? this.getOptions(type).getStringList(key) : new ArrayList<String>();
    }

    @Override
    public Map<String, Object> optionMap(T type, String key) {
        return this.isLoaded(type) ? this.getOptions(type).getMap(key) : new ConcurrentHashMap<String, Object>();
    }
}

