/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.migration;

import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.migration.ConfigMigrator;
import dev.aurelium.auraskills.common.migration.FileUserMigrator;
import dev.aurelium.auraskills.common.migration.SqlUserMigrator;
import dev.aurelium.auraskills.common.storage.StorageProvider;
import dev.aurelium.auraskills.common.storage.sql.SqlStorageProvider;
import dev.aurelium.auraskills.common.util.file.FileUtil;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import java.io.File;

public class MigrationManager {
    private final AuraSkillsPlugin plugin;

    public MigrationManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
    }

    public void attemptConfigMigration() {
        try {
            File mainConfig = new File(this.plugin.getPluginFolder(), "config.yml");
            ConfigurationNode config = FileUtil.loadYamlFile(mainConfig);
            boolean migrateConfig = this.shouldMigrate("config_migration_complete", config);
            if (!migrateConfig) {
                return;
            }
            this.plugin.logger().warn("[Migrator] As part of the 2.0 update, the plugin has been renamed from AureliumSkills to AuraSkills and config files have had format changes");
            this.plugin.logger().warn("[Migrator] Watch the following log messages for errors and report any to the Aurelium Discord");
            this.plugin.logger().warn("[Migrator] Attempting to migrate config files from AureliumSkills to AuraSkills");
            ConfigMigrator configMigrator = new ConfigMigrator(this.plugin);
            configMigrator.migrate();
            config = FileUtil.loadYamlFile(mainConfig);
            this.setMigrated("config_migration_complete", config);
            FileUtil.saveYamlFile(new File(this.plugin.getPluginFolder(), "config.yml"), config);
        }
        catch (Exception e) {
            this.plugin.logger().severe("[Migrator] Error while migrating, please report this to the plugin Discord!");
            e.printStackTrace();
        }
    }

    public void attemptUserMigration() {
        try {
            ConfigurationNode config = FileUtil.loadYamlFile(new File(this.plugin.getPluginFolder(), "config.yml"));
            boolean migrateFileUser = this.shouldMigrate("file_user_migration_complete", config);
            boolean migrateSqlUser = this.shouldMigrate("sql_user_migration_complete", config);
            if (!migrateFileUser && !migrateSqlUser) {
                return;
            }
            if (migrateFileUser) {
                FileUserMigrator fileUserMigrator = new FileUserMigrator(this.plugin);
                fileUserMigrator.migrate();
                this.setMigrated("file_user_migration_complete", config);
            }
            if (migrateSqlUser) {
                StorageProvider storageProvider = this.plugin.getStorageProvider();
                if (storageProvider instanceof SqlStorageProvider) {
                    SqlStorageProvider storageProvider2 = (SqlStorageProvider)storageProvider;
                    SqlUserMigrator sqlUserMigrator = new SqlUserMigrator(this.plugin, storageProvider2);
                    sqlUserMigrator.migrate();
                }
                this.setMigrated("sql_user_migration_complete", config);
            }
            FileUtil.saveYamlFile(new File(this.plugin.getPluginFolder(), "config.yml"), config);
        }
        catch (Exception e) {
            this.plugin.logger().severe("[Migrator] Error while migrating, please report this to the plugin Discord!");
            e.printStackTrace();
        }
    }

    public boolean shouldMigrate(String key, ConfigurationNode config) {
        File aureliumDir = new File(this.plugin.getPluginFolder().getParentFile(), "AureliumSkills");
        boolean migrationCompleted = config.node("metadata", key).getBoolean(true);
        return aureliumDir.exists() && !migrationCompleted;
    }

    public void setMigrated(String key, ConfigurationNode config) throws SerializationException {
        config.node("metadata", key).set(true);
    }
}

