/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.mana;

import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.mana.LoadedManaAbility;
import dev.aurelium.auraskills.common.mana.ManaAbilitySupplier;
import dev.aurelium.auraskills.common.user.User;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ManaAbilityManager {
    private final Map<ManaAbility, LoadedManaAbility> manaAbilityMap = new ConcurrentHashMap<ManaAbility, LoadedManaAbility>();
    private final ManaAbilitySupplier supplier;

    public ManaAbilityManager(AuraSkillsPlugin plugin) {
        this.supplier = new ManaAbilitySupplier(plugin, this);
    }

    public ManaAbilitySupplier getSupplier() {
        return this.supplier;
    }

    public void register(ManaAbility manaAbility, LoadedManaAbility loadedManaAbility) {
        this.manaAbilityMap.put(manaAbility, loadedManaAbility);
    }

    public void unregisterAll() {
        this.manaAbilityMap.clear();
    }

    @NotNull
    public LoadedManaAbility getManaAbility(ManaAbility manaAbility) {
        LoadedManaAbility loadedMana = this.manaAbilityMap.get(manaAbility);
        if (loadedMana == null) {
            throw new IllegalArgumentException("Mana ability " + String.valueOf(manaAbility) + " is not loaded!");
        }
        return loadedMana;
    }

    @Nullable
    public ManaAbility getManaAbilityAtLevel(Skill skill, int level) {
        ManaAbility manaAbility = skill.getManaAbility();
        if (manaAbility != null) {
            int manaAbilityLevel = (level - manaAbility.getUnlock()) / manaAbility.getLevelUp() + 1;
            if (manaAbility.getMaxLevel() > 0 && manaAbilityLevel > manaAbility.getMaxLevel()) {
                return null;
            }
            if (level >= manaAbility.getUnlock() && (level - manaAbility.getUnlock()) % manaAbility.getLevelUp() == 0) {
                return manaAbility;
            }
        }
        return null;
    }

    public boolean isLoaded(ManaAbility manaAbility) {
        return this.manaAbilityMap.containsKey(manaAbility);
    }

    public abstract void sendNotEnoughManaMessage(User var1, double var2);

    public abstract String getBaseDescription(ManaAbility var1, User var2, boolean var3);
}

