/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.api.implementation;

import dev.aurelium.auraskills.api.user.SkillsUser;
import dev.aurelium.auraskills.api.user.UserManager;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.api.implementation.ApiSkillsUser;
import dev.aurelium.auraskills.common.api.implementation.OfflineSkillsUser;
import dev.aurelium.auraskills.common.user.User;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class ApiUserManager
implements UserManager {
    private final AuraSkillsPlugin plugin;

    public ApiUserManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public SkillsUser getUser(UUID playerId) {
        User user = this.plugin.getUserManager().getUser(playerId);
        if (user != null) {
            return new ApiSkillsUser(user);
        }
        return new OfflineSkillsUser(this.plugin, playerId);
    }

    @Override
    public CompletableFuture<SkillsUser> loadUser(UUID playerId) {
        CompletableFuture<SkillsUser> future = new CompletableFuture<SkillsUser>();
        User onlineUser = this.plugin.getUserManager().getUser(playerId);
        if (onlineUser != null) {
            future.complete(new ApiSkillsUser(onlineUser));
        } else {
            this.plugin.getScheduler().executeAsync(() -> {
                try {
                    this.plugin.getStorageProvider().load(playerId, null);
                    User loadedUser = this.plugin.getUserManager().getUser(playerId);
                    if (loadedUser != null) {
                        future.complete(new ApiSkillsUser(loadedUser));
                    } else {
                        future.complete(new OfflineSkillsUser(this.plugin, playerId));
                    }
                }
                catch (Exception e) {
                    future.complete(new OfflineSkillsUser(this.plugin, playerId));
                    e.printStackTrace();
                }
            });
        }
        return future;
    }
}

