/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.api.implementation;

import dev.aurelium.auraskills.api.config.ConfigNode;
import dev.aurelium.auraskills.api.source.CustomSource;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.SourceIncome;
import dev.aurelium.auraskills.api.source.SourceManager;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.api.implementation.ApiConfigNode;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.source.income.IncomeLoader;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApiSourceManager
implements SourceManager {
    private final AuraSkillsPlugin plugin;
    private final IncomeLoader incomeLoader;

    public ApiSourceManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.incomeLoader = new IncomeLoader(plugin);
    }

    @Override
    @NotNull
    public <T extends XpSource> List<SkillSource<T>> getSourcesOfType(Class<T> typeClass) {
        return this.plugin.getSkillManager().getSourcesOfType(typeClass);
    }

    @Override
    @Nullable
    public <T extends XpSource> SkillSource<T> getSingleSourceOfType(Class<T> typeClass) {
        return this.plugin.getSkillManager().getSingleSourceOfType(typeClass);
    }

    @Override
    @Nullable
    public String getUnitName(XpSource source, Locale locale) {
        String unitName = this.plugin.getItemRegistry().getSourceMenuItems().getSourceUnit(source);
        if (unitName == null && source instanceof CustomSource) {
            CustomSource customSource = (CustomSource)source;
            unitName = customSource.getValues().getUnitName();
        }
        if (unitName == null) {
            return null;
        }
        for (String keyStr : TextUtil.getPlaceholders(unitName)) {
            MessageKey key = MessageKey.of(keyStr);
            String message = this.plugin.getMsg(key, locale);
            unitName = TextUtil.replace(unitName, "{" + keyStr + "}", message);
        }
        return unitName;
    }

    @Override
    public SourceIncome loadSourceIncome(ConfigNode source) {
        return this.incomeLoader.loadSourceIncome(((ApiConfigNode)source).getBacking());
    }
}

