/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.antiafk;

import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.antiafk.AntiAfkManager;
import dev.aurelium.auraskills.common.antiafk.CheckData;
import dev.aurelium.auraskills.common.antiafk.CheckType;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.ref.PlayerRef;
import dev.aurelium.auraskills.evalex.EvaluationException;
import dev.aurelium.auraskills.evalex.parser.ParseException;
import java.util.Locale;
import org.jetbrains.annotations.VisibleForTesting;

public class Check {
    protected final AuraSkillsPlugin plugin;
    private final CheckType type;
    private final AntiAfkManager manager;
    private final String configPrefix;
    private final Option enabledOption;
    private final int logThreshold;

    public Check(CheckType type, AntiAfkManager manager) {
        int logThresholdParsed;
        this.type = type;
        this.manager = manager;
        this.plugin = manager.getPlugin();
        this.configPrefix = "ANTI_AFK_CHECKS_" + type.toString() + "_";
        this.enabledOption = Option.valueOf(this.configPrefix + "ENABLED");
        int minCount = this.optionInt("min_count");
        try {
            logThresholdParsed = manager.getLogThresholdExpression().with("min_count", minCount).evaluate().getNumberValue().intValue();
        }
        catch (EvaluationException | ParseException e) {
            this.plugin.logger().warn("Failed to evaluate anti_afk.log_threshold expression: " + e.getMessage());
            e.printStackTrace();
            logThresholdParsed = minCount;
        }
        this.logThreshold = logThresholdParsed;
    }

    public int getLogThreshold() {
        return this.logThreshold;
    }

    protected CheckData getCheckData(PlayerRef ref) {
        return this.manager.getCheckData(ref, this.type);
    }

    protected void logFail(PlayerRef player) {
        if (!this.plugin.configBoolean(Option.ANTI_AFK_LOGGING_ENABLED)) {
            return;
        }
        CheckData checkData = this.getCheckData(player);
        if (checkData.getLogCount() >= this.logThreshold) {
            this.manager.logAndNotifyFail(player, this.type, checkData);
            checkData.resetLogCount();
        }
    }

    @VisibleForTesting
    public boolean isDisabled() {
        return !this.plugin.configBoolean(this.enabledOption);
    }

    protected int optionInt(String option) {
        return this.plugin.configInt(Option.valueOf(this.configPrefix + option.toUpperCase(Locale.ROOT)));
    }

    protected double optionDouble(String option) {
        return this.plugin.configDouble(Option.valueOf(this.configPrefix + option.toUpperCase(Locale.ROOT)));
    }

    protected String optionString(String option) {
        return this.plugin.configString(Option.valueOf(this.configPrefix + option.toUpperCase(Locale.ROOT)));
    }

    protected boolean optionBoolean(String option) {
        return this.plugin.configBoolean(Option.valueOf(this.configPrefix + option.toUpperCase(Locale.ROOT)));
    }
}

