/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.common.ability;

import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.ability.AbstractAbility;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.ability.AbilityImpl;
import dev.aurelium.auraskills.common.ability.AbilitySupplier;
import dev.aurelium.auraskills.common.ability.LoadedAbility;
import dev.aurelium.auraskills.common.user.User;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbilityManager {
    private final AuraSkillsPlugin plugin;
    private final Map<Ability, LoadedAbility> abilityMap;
    private final AbilitySupplier supplier;
    protected final Map<Class<?>, AbilityImpl> abilityImpls = new ConcurrentHashMap();

    public AbilityManager(AuraSkillsPlugin plugin) {
        this.plugin = plugin;
        this.abilityMap = new ConcurrentHashMap<Ability, LoadedAbility>();
        this.supplier = new AbilitySupplier(this, plugin.getMessageProvider());
    }

    public abstract void registerAbilityImplementations();

    public abstract void sendAbilityMessage(User var1, String var2);

    protected void addImplToMap(AbilityImpl abilityImpl) {
        this.abilityImpls.put(abilityImpl.getClass(), abilityImpl);
    }

    public <T extends AbilityImpl> T getAbilityImpl(Class<T> clazz) {
        AbilityImpl abilityImpl = this.abilityImpls.get(clazz);
        if (abilityImpl != null) {
            return (T)((AbilityImpl)clazz.cast(abilityImpl));
        }
        throw new IllegalArgumentException("Ability implementation of type " + clazz.getSimpleName() + " not found!");
    }

    @Nullable
    public AbilityImpl getAbilityImpl(Ability ability) {
        for (AbilityImpl impl : this.abilityImpls.values()) {
            if (!impl.getAbilities().contains(ability)) continue;
            return impl;
        }
        return null;
    }

    public String getBaseDescription(Ability ability, User user, boolean formatted) {
        String desc = ability.getDescription(user.getLocale(), formatted);
        AbilityImpl impl = this.plugin.getAbilityManager().getAbilityImpl(ability);
        if (impl != null) {
            desc = impl.replaceDescPlaceholders(desc, ability, user);
        }
        return desc;
    }

    public AbilitySupplier getSupplier() {
        return this.supplier;
    }

    public void register(Ability ability, LoadedAbility loadedAbility) {
        this.abilityMap.put(ability, loadedAbility);
    }

    public void unregisterAll() {
        this.abilityMap.clear();
    }

    @NotNull
    public LoadedAbility getAbility(Ability ability) {
        LoadedAbility loadedAbility = this.abilityMap.get(ability);
        if (loadedAbility == null) {
            throw new IllegalArgumentException("Ability " + String.valueOf(ability) + " is not loaded!");
        }
        return loadedAbility;
    }

    public List<Ability> getAbilities(Skill skill, int level) {
        List<Ability> skillAbilities = skill.getAbilities();
        ArrayList<Ability> abilities = new ArrayList<Ability>();
        for (Ability ability : skillAbilities) {
            int abilityLevel = (level - ability.getUnlock()) / ability.getLevelUp() + 1;
            if (ability.getMaxLevel() > 0 && abilityLevel > ability.getMaxLevel() || level < ability.getUnlock() || (level - ability.getUnlock()) % ability.getLevelUp() != 0) continue;
            abilities.add(ability);
        }
        return abilities;
    }

    @Nullable
    public AbstractAbility getAbstractAbility(NamespacedId id) {
        try {
            return (AbstractAbility)this.plugin.getAbilityRegistry().get(id);
        }
        catch (IllegalArgumentException e) {
            try {
                return (AbstractAbility)this.plugin.getManaAbilityRegistry().get(id);
            }
            catch (IllegalArgumentException f) {
                return null;
            }
        }
    }

    public boolean isLoaded(Ability ability) {
        return this.abilityMap.containsKey(ability);
    }

    public String getChanceValue(Ability ability, int level) {
        return NumberUtil.format1(ability.getValue(level) - Math.floor(ability.getValue(level) / 100.0) * 100.0);
    }

    public String getGuaranteedValue(Ability ability, int level) {
        return String.valueOf((int)ability.getValue(level) / 100);
    }
}

