/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.util.armor;

import dev.aurelium.auraskills.bukkit.util.armor.ArmorListener;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public enum ArmorType {
    HELMET(5),
    CHESTPLATE(6),
    LEGGINGS(7),
    BOOTS(8);

    private final int slot;

    private ArmorType(int slot) {
        this.slot = slot;
    }

    public static ArmorType matchType(ItemStack itemStack) {
        if (ArmorListener.isAirOrNull(itemStack)) {
            return null;
        }
        String type = itemStack.getType().name();
        if (type.endsWith("_HELMET") || type.endsWith("_SKULL") || type.endsWith("_HEAD") || type.endsWith("SKULL_ITEM") || type.equals("CARVED_PUMPKIN")) {
            return HELMET;
        }
        if (type.endsWith("_CHESTPLATE") || type.equals("ELYTRA")) {
            return CHESTPLATE;
        }
        if (type.endsWith("_LEGGINGS")) {
            return LEGGINGS;
        }
        if (type.endsWith("_BOOTS")) {
            return BOOTS;
        }
        return null;
    }

    public int getSlot() {
        return this.slot;
    }

    public EquipmentSlot getEquipmentSlot() {
        switch (this.ordinal()) {
            case 0: {
                return EquipmentSlot.HEAD;
            }
            case 1: {
                return EquipmentSlot.CHEST;
            }
            case 2: {
                return EquipmentSlot.LEGS;
            }
        }
        return EquipmentSlot.FEET;
    }
}

