/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.util;

import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class VersionUtils {
    public static final int MAJOR_VERSION = VersionUtils.getMajorVersion(VersionUtils.getVersionString(Bukkit.getBukkitVersion()));
    public static final int MINOR_VERSION = VersionUtils.getMinorVersion(VersionUtils.getVersionString(Bukkit.getBukkitVersion()));
    private static final int FALLBACK_MAJOR_VERSION = 17;
    private static final int FALLBACK_MINOR_VERSION = 0;

    public static boolean isPigman(EntityType type) {
        if (MAJOR_VERSION == 16) {
            return type.equals((Object)EntityType.ZOMBIFIED_PIGLIN);
        }
        return type.name().equals("PIG_ZOMBIE");
    }

    public static boolean isAtLeastVersion(int version) {
        return MAJOR_VERSION >= version;
    }

    public static boolean isAtLeastVersion(int majorVersionReq, int minorVersionReq) {
        if (MAJOR_VERSION > majorVersionReq) {
            return true;
        }
        if (MAJOR_VERSION == majorVersionReq) {
            return MINOR_VERSION >= minorVersionReq;
        }
        return false;
    }

    public static int getMinorVersion(String version) {
        try {
            if (version != null) {
                int lastDot = version.lastIndexOf(46);
                if (version.indexOf(46) != lastDot) {
                    return Integer.parseInt(version.substring(lastDot + 1));
                }
                return 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static int getMajorVersion(String version) {
        try {
            if (version != null) {
                int lastDot = version.lastIndexOf(".");
                int firstDot = version.indexOf(".");
                if (firstDot != lastDot) {
                    String sub = version.substring(firstDot + 1, lastDot);
                    if (sub.contains(".")) {
                        sub = sub.substring(0, sub.indexOf("."));
                    }
                    return Integer.parseInt(sub);
                }
                return Integer.parseInt(version.substring(firstDot + 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 17;
    }

    public static String getVersionString(@Nullable String version) {
        if (version == null || version.isEmpty()) {
            return null;
        }
        int index = version.lastIndexOf("MC:");
        if (index != -1) {
            version = version.substring(index + 4, version.length() - 1);
        } else if (version.endsWith("SNAPSHOT")) {
            index = version.indexOf(45);
            version = version.substring(0, index);
        }
        version = version.split(" ")[0];
        return version;
    }
}

