/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.util;

import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class CompatUtil {
    public static boolean hasEffect(Player player, Set<String> names) {
        PotionEffect effect = CompatUtil.getEffect(player, names);
        return effect != null;
    }

    @Nullable
    public static PotionEffect getEffect(Player player, Set<String> names) {
        if (VersionUtils.isAtLeastVersion(18)) {
            for (PotionEffect effect : player.getActivePotionEffects()) {
                if (!names.contains(effect.getType().getKey().getKey())) continue;
                return effect;
            }
        } else {
            for (PotionEffect effect : player.getActivePotionEffects()) {
                if (!names.contains(effect.getType().getName().toLowerCase(Locale.ROOT))) continue;
                return effect;
            }
        }
        return null;
    }

    public static boolean isEffect(PotionEffectType type, Set<String> names) {
        if (VersionUtils.isAtLeastVersion(18)) {
            return names.contains(type.getKey().getKey());
        }
        return names.contains(type.getName().toLowerCase(Locale.ROOT));
    }

    public static PotionEffectType haste() {
        if (VersionUtils.isAtLeastVersion(20, 5)) {
            return PotionEffectType.HASTE;
        }
        return PotionEffectType.getByName((String)"FAST_DIGGING");
    }

    public static PotionEffectType resistance() {
        if (VersionUtils.isAtLeastVersion(20, 5)) {
            return PotionEffectType.RESISTANCE;
        }
        return PotionEffectType.getByName((String)"DAMAGE_RESISTANCE");
    }

    public static PotionEffectType slowness() {
        if (VersionUtils.isAtLeastVersion(20, 5)) {
            return PotionEffectType.SLOWNESS;
        }
        return PotionEffectType.getByName((String)"SLOW");
    }

    public static PotionEffectType jumpBoost() {
        if (VersionUtils.isAtLeastVersion(20, 5)) {
            return PotionEffectType.JUMP_BOOST;
        }
        return PotionEffectType.getByName((String)"JUMP");
    }

    public static Material getTurtleScute() {
        if (VersionUtils.isAtLeastVersion(20, 5)) {
            return Material.TURTLE_SCUTE;
        }
        return Material.valueOf((String)"SCUTE");
    }

    public static Particle villagerParticle() {
        if (VersionUtils.isAtLeastVersion(20, 5)) {
            return Particle.HAPPY_VILLAGER;
        }
        return Particle.valueOf((String)"VILLAGER_HAPPY");
    }

    public static Particle dustParticle() {
        if (VersionUtils.isAtLeastVersion(20, 5)) {
            return Particle.BLOCK;
        }
        return Particle.valueOf((String)"BLOCK_DUST");
    }

    public static Particle blockParticle() {
        if (VersionUtils.isAtLeastVersion(20, 5)) {
            return Particle.DUST;
        }
        return Particle.valueOf((String)"REDSTONE");
    }

    public static Particle witchParticle() {
        if (VersionUtils.isAtLeastVersion(20, 5)) {
            return Particle.WITCH;
        }
        return Particle.valueOf((String)"SPELL_WITCH");
    }
}

