/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.util;

import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;

public class AttributeCompat {
    public static Attribute maxHealth;
    public static Attribute movementSpeed;
    public static Attribute attackDamage;
    public static Attribute attackSpeed;
    public static Attribute luck;

    private static Attribute fromRegistry(String key) {
        Attribute attribute = (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)key));
        if (attribute == null) {
            throw new IllegalArgumentException("Could not find attribute with key " + key + " in Attribute registry");
        }
        return attribute;
    }

    static {
        if (VersionUtils.isAtLeastVersion(21, 2)) {
            maxHealth = AttributeCompat.fromRegistry("max_health");
            movementSpeed = AttributeCompat.fromRegistry("movement_speed");
            attackDamage = AttributeCompat.fromRegistry("attack_damage");
            attackSpeed = AttributeCompat.fromRegistry("attack_speed");
            luck = AttributeCompat.fromRegistry("luck");
        } else {
            maxHealth = AttributeCompat.fromRegistry("generic.max_health");
            movementSpeed = AttributeCompat.fromRegistry("generic.movement_speed");
            attackDamage = AttributeCompat.fromRegistry("generic.attack_damage");
            attackSpeed = AttributeCompat.fromRegistry("generic.attack_speed");
            luck = AttributeCompat.fromRegistry("generic.luck");
        }
    }
}

