/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.user;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.user.SkillsUser;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.BukkitLuckPermsHook;
import dev.aurelium.auraskills.bukkit.item.TraitModifiers;
import dev.aurelium.auraskills.bukkit.item.UserEquipment;
import dev.aurelium.auraskills.common.api.implementation.ApiSkillsUser;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.kyori.adventure.text.Component;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitUser
extends User {
    @Nullable
    private final Player player;
    private final AuraSkills plugin;
    private final UserEquipment equipment;

    public BukkitUser(UUID uuid, @Nullable Player player, AuraSkills plugin) {
        super(uuid, plugin);
        this.player = player;
        this.plugin = plugin;
        this.equipment = UserEquipment.empty();
    }

    @Nullable
    public static Player getPlayer(User user) {
        return ((BukkitUser)user).getPlayer();
    }

    @Nullable
    public static Player getPlayer(SkillsUser skillsUser) {
        return ((BukkitUser)((ApiSkillsUser)skillsUser).getUser()).getPlayer();
    }

    public static BukkitUser getUser(SkillsUser skillsUser) {
        return (BukkitUser)((ApiSkillsUser)skillsUser).getUser();
    }

    @NotNull
    public UserEquipment getEquipment() {
        return this.equipment;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public String getUsername() {
        String name = Bukkit.getOfflinePlayer((UUID)this.uuid).getName();
        return name != null ? name : "?";
    }

    @Override
    public void sendMessage(String message) {
        if (this.player != null) {
            this.player.sendMessage(message);
        }
    }

    @Override
    public void sendMessage(Component component) {
        if (this.plugin.getMessageProvider().componentToString(component).isEmpty()) {
            return;
        }
        if (this.player != null) {
            this.plugin.getAudiences().player(this.player).sendMessage(component);
        }
    }

    @Override
    public double getPermissionMultiplier(@Nullable Skill skill) {
        if (this.player == null) {
            return 0.0;
        }
        double multiplier = 0.0;
        if (this.plugin.getHookManager().isRegistered(BukkitLuckPermsHook.class) && this.plugin.getHookManager().getHook(BukkitLuckPermsHook.class).usePermissionCache()) {
            Set<String> permissions = this.plugin.getHookManager().getHook(BukkitLuckPermsHook.class).getMultiplierPermissions(this.player);
            for (String permission : permissions) {
                multiplier += this.getMultiplierFromPermission(permission, skill);
            }
            return multiplier;
        }
        for (PermissionAttachmentInfo permission : this.player.getEffectivePermissions()) {
            if (!permission.getValue()) continue;
            multiplier += this.getMultiplierFromPermission(permission.getPermission(), skill);
        }
        return multiplier;
    }

    private double getMultiplierFromPermission(String permission, @Nullable Skill skill) {
        String prefix = "auraskills.multiplier.";
        if (!permission.startsWith("auraskills.multiplier.")) {
            return 0.0;
        }
        if (this.isNumeric(permission = permission.substring("auraskills.multiplier.".length()))) {
            return Double.parseDouble(permission) / 100.0;
        }
        if (skill != null) {
            String namespacedName = skill.toString().toLowerCase(Locale.ROOT) + ".";
            String plainName = skill.name().toLowerCase(Locale.ROOT) + ".";
            if (permission.startsWith(namespacedName)) {
                permission = permission.substring(namespacedName.length());
            } else if (permission.startsWith(plainName)) {
                permission = permission.substring(plainName.length());
            } else {
                return 0.0;
            }
            if (this.isNumeric(permission)) {
                return Double.parseDouble(permission) / 100.0;
            }
        }
        return 0.0;
    }

    private boolean isNumeric(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        boolean decimalSeen = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (i == 0 && c == '-') {
                if (str.length() != 1) continue;
                return false;
            }
            if (c == '.') {
                if (decimalSeen || i == 0 || i == str.length() - 1) {
                    return false;
                }
                decimalSeen = true;
                continue;
            }
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasSkillPermission(Skill skill) {
        if (this.player == null) {
            return true;
        }
        return this.player.hasPermission("auraskills.skill." + skill.name().toLowerCase(Locale.ROOT));
    }

    @Override
    public void setCommandLocale(Locale locale) {
        if (this.player != null) {
            this.plugin.getCommandManager().setPlayerLocale(this.player, locale);
        }
    }

    @Override
    public int getPermissionJobLimit() {
        if (this.player == null) {
            return 0;
        }
        String prefix = "auraskills.jobs.limit.";
        int highestLimit = 0;
        for (PermissionAttachmentInfo permissionInfo : this.player.getEffectivePermissions()) {
            String permission = permissionInfo.getPermission();
            if (!permission.startsWith("auraskills.jobs.limit.") || !this.isNumeric(permission = permission.substring("auraskills.jobs.limit.".length()))) continue;
            try {
                int value = Integer.parseInt(permission);
                if (value <= highestLimit) continue;
                highestLimit = value;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return highestLimit;
    }

    @Override
    public String getWorld() {
        if (this.player == null) {
            return ((World)this.plugin.getServer().getWorlds().getFirst()).getName();
        }
        return this.player.getWorld().getName();
    }

    @Override
    public boolean hasPermission(String permission) {
        if (this.player == null) {
            return false;
        }
        return this.player.hasPermission(permission);
    }

    @Override
    public boolean canSelectJob(@NotNull Skill skill) {
        if (this.player == null) {
            return true;
        }
        String prefix = "auraskills.jobs.block.";
        for (PermissionAttachmentInfo permissionInfo : this.player.getEffectivePermissions()) {
            String skillName;
            String permission = permissionInfo.getPermission();
            if (!permission.startsWith("auraskills.jobs.block.") || !(skillName = permission.substring("auraskills.jobs.block.".length())).equals(skill.getId().getKey()) && !skillName.equals(skill.getId().toString()) || !permissionInfo.getValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.removeTraitModifier(TraitModifiers.FLEETING.getModifierId(), false);
    }
}

