/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.trait;

import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.region.BukkitWorldManager;
import dev.aurelium.auraskills.bukkit.skills.agility.AgilityAbilities;
import dev.aurelium.auraskills.bukkit.trait.TraitImpl;
import dev.aurelium.auraskills.bukkit.util.AttributeCompat;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.data.DataUtil;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class HpTrait
extends TraitImpl {
    private final Map<UUID, Double> worldChangeHealth = new ConcurrentHashMap<UUID, Double>();
    private final Map<Integer, Double> hearts = new ConcurrentHashMap<Integer, Double>();
    private static final double threshold = 0.1;
    private static final UUID ATTRIBUTE_ID = UUID.fromString("7d1423dd-91db-467a-8eb8-1886e30ca0b1");
    private static final String ATTRIBUTE_KEY = "hp_trait";

    HpTrait(AuraSkills plugin) {
        super(plugin, Traits.HP);
        this.hearts.put(10, 0.0);
        this.hearts.put(11, 24.0);
        this.hearts.put(12, 29.0);
        this.hearts.put(13, 37.0);
        this.hearts.put(14, 50.0);
        this.hearts.put(15, 71.0);
        this.hearts.put(16, 105.0);
        this.hearts.put(17, 160.0);
        this.hearts.put(18, 249.0);
        this.hearts.put(19, 393.0);
        this.hearts.put(20, 626.0);
        this.loadHearts();
    }

    @Override
    public double getBaseLevel(Player player, Trait trait) {
        AttributeInstance attribute = player.getAttribute(AttributeCompat.maxHealth);
        if (attribute == null) {
            return 0.0;
        }
        double current = attribute.getValue();
        for (AttributeModifier am : attribute.getModifiers()) {
            if (!this.isSkillsHealthModifier(am)) continue;
            current -= am.getAmount();
        }
        return current;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.applyScaling(event.getPlayer());
    }

    @Override
    public void reload(Player player, Trait trait) {
        if (this.plugin.getScheduler().isFolia()) {
            this.plugin.getScheduler().executeAtEntity((Entity)player, task -> this.reloadHp(player));
        } else {
            this.reloadHp(player);
        }
    }

    private void reloadHp(Player player) {
        this.setHealth(player, this.plugin.getUser(player));
        this.plugin.getAbilityManager().getAbilityImpl(AgilityAbilities.class).removeFleeting(player);
    }

    public String getMenuDisplay(double value, Trait trait, @Nullable NumberFormat format) {
        double scaling = trait.optionDouble("action_bar_scaling", 1.0);
        double display = scaling * value;
        return format != null ? format.format(display) : NumberUtil.format1(display);
    }

    @Override
    public String getMenuDisplay(double value, Trait trait, Locale locale) {
        return this.getMenuDisplay(value, trait, (NumberFormat)null);
    }

    @Override
    public void changeWorld(PlayerChangedWorldEvent event, Trait trait) {
        if (!trait.equals(Traits.HP)) {
            return;
        }
        if (!Traits.HP.isEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation()) && !this.plugin.getWorldManager().isDisabledWorld(event.getFrom().getName())) {
            this.worldChangeHealth.put(player.getUniqueId(), player.getHealth());
        }
        User user = this.plugin.getUser(player);
        if (Traits.HP.optionInt("update_delay") > 0) {
            this.plugin.getScheduler().scheduleAtEntity((Entity)player, () -> this.setWorldChange(event, player, user), (long)Traits.HP.optionInt("update_delay") * 50L, TimeUnit.MILLISECONDS);
        } else {
            this.setWorldChange(event, player, user);
        }
    }

    private void setWorldChange(PlayerChangedWorldEvent event, Player player, User user) {
        this.setHealth(player, user);
        BukkitWorldManager worldManager = this.plugin.getWorldManager();
        if (!worldManager.isDisabledWorld(event.getFrom().getName()) || worldManager.isInDisabledWorld(player.getLocation())) {
            return;
        }
        UUID playerID = player.getUniqueId();
        if (!this.worldChangeHealth.containsKey(playerID)) {
            return;
        }
        AttributeInstance attribute = player.getAttribute(AttributeCompat.maxHealth);
        double maxHealth = attribute == null ? 20.0 : attribute.getValue();
        double newHealth = this.worldChangeHealth.get(playerID);
        if (newHealth > maxHealth) {
            newHealth = maxHealth;
        }
        player.setHealth(newHealth);
        this.worldChangeHealth.remove(playerID);
    }

    private void setHealth(Player player, User user) {
        Traits trait = Traits.HP;
        double modifier = user.getBonusTraitLevel(trait);
        AttributeInstance attribute = player.getAttribute(AttributeCompat.maxHealth);
        if (attribute == null) {
            return;
        }
        double originalMaxHealth = attribute.getValue();
        boolean hasChange = true;
        for (AttributeModifier am : attribute.getModifiers()) {
            if (!this.isSkillsHealthModifier(am)) continue;
            if (Math.abs(originalMaxHealth - (originalMaxHealth - am.getAmount() + modifier)) <= 0.1) {
                hasChange = false;
            }
            if (!hasChange) continue;
            attribute.removeModifier(am);
        }
        if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation()) || !trait.isEnabled()) {
            player.setHealthScaled(false);
            for (AttributeModifier am : attribute.getModifiers()) {
                if (!this.isSkillsHealthModifier(am)) continue;
                attribute.removeModifier(am);
            }
            if (player.getHealth() >= originalMaxHealth) {
                player.setHealth(attribute.getValue());
            }
            return;
        }
        if (trait.optionBoolean("force_base_health", false)) {
            attribute.setBaseValue(20.0);
        }
        if (hasChange) {
            if (VersionUtils.isAtLeastVersion(21)) {
                NamespacedKey modifierKey = new NamespacedKey((Plugin)this.plugin, ATTRIBUTE_KEY);
                attribute.addModifier(new AttributeModifier(modifierKey, modifier, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY));
            } else {
                attribute.addModifier(new AttributeModifier(ATTRIBUTE_ID, "skillsHealth", modifier, AttributeModifier.Operation.ADD_NUMBER));
            }
            if (player.getHealth() > attribute.getValue()) {
                player.setHealth(attribute.getValue());
            }
            if (trait.optionBoolean("keep_full_on_increase", false) && attribute.getValue() > originalMaxHealth) {
                double threshold = 0.01;
                if (player.getHealth() >= originalMaxHealth - 0.01) {
                    player.setHealth(attribute.getValue());
                }
            }
        }
        this.applyScaling(player);
    }

    private boolean isSkillsHealthModifier(AttributeModifier am) {
        if (am.getName().equals("skillsHealth")) {
            return true;
        }
        if (VersionUtils.isAtLeastVersion(21)) {
            String namespace = am.getKey().getNamespace();
            String key = am.getKey().getKey();
            if (key.equals(ATTRIBUTE_ID.toString())) {
                return true;
            }
            String attributeNamespace = "auraskills";
            return namespace.equals("auraskills") && key.equals(ATTRIBUTE_KEY);
        }
        return false;
    }

    private void applyScaling(Player player) {
        AttributeInstance attribute = player.getAttribute(AttributeCompat.maxHealth);
        if (attribute == null) {
            return;
        }
        if (Traits.HP.isEnabled() && Traits.HP.optionBoolean("health_scaling", true)) {
            double health = attribute.getValue();
            player.setHealthScaled(true);
            int scaledHearts = 0;
            for (Integer heartNum : this.hearts.keySet()) {
                double healthNum = this.hearts.get(heartNum);
                if (!(health >= healthNum) || heartNum <= scaledHearts) continue;
                scaledHearts = heartNum;
            }
            if (scaledHearts == 0) {
                scaledHearts = 10;
            }
            player.setHealthScale((double)(scaledHearts * 2));
        } else if (Traits.HP.optionBoolean("ensure_scaling_disabled", true)) {
            player.setHealthScaled(false);
        }
    }

    public void loadHearts() {
        this.hearts.clear();
        Map<String, Object> map = Traits.HP.optionMap("hearts");
        try {
            for (String key : map.keySet()) {
                int heartsNum = Integer.parseInt(key);
                double healthNum = DataUtil.getDouble(map, key);
                if (healthNum == -1.0) continue;
                this.hearts.put(heartsNum, healthNum);
            }
        }
        catch (Exception e) {
            this.plugin.logger().warn("There was an error loading health.hearts data! Check to make sure the keys are only integers and the values are only numbers.");
        }
    }
}

