/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.source;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.PotionSplashXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.source.SourceLeveler;
import dev.aurelium.auraskills.common.source.SourceTypes;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.Nullable;

public class PotionSplashLeveler
extends SourceLeveler {
    public PotionSplashLeveler(AuraSkills plugin) {
        super(plugin, SourceTypes.POTION_SPLASH);
    }

    @EventHandler
    public void onSplash(PotionSplashEvent event) {
        this.handle((ProjectileHitEvent)event);
    }

    @EventHandler
    public void onLingeringSplash(LingeringPotionSplashEvent event) {
        this.handle((ProjectileHitEvent)event);
    }

    public void handle(ProjectileHitEvent event) {
        if (this.disabled()) {
            return;
        }
        if (!(event instanceof PotionSplashEvent) && !(event instanceof LingeringPotionSplashEvent)) {
            return;
        }
        ThrownPotion potion = (ThrownPotion)event.getEntity();
        ProjectileSource projectileSource = potion.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        if (potion.getEffects().isEmpty()) {
            return;
        }
        ItemStack item = potion.getItem();
        SkillSource<PotionSplashXpSource> skillSource = this.getSource(item);
        if (skillSource == null) {
            return;
        }
        PotionSplashXpSource source = skillSource.source();
        Skill skill = skillSource.skill();
        if (this.failsChecks((Cancellable)event, player, potion.getLocation(), skill)) {
            return;
        }
        this.plugin.getLevelManager().addXp(this.plugin.getUser(player), skill, source, source.getXp());
    }

    @Nullable
    private SkillSource<PotionSplashXpSource> getSource(ItemStack item) {
        for (SkillSource<PotionSplashXpSource> entry : this.plugin.getSkillManager().getSourcesOfType(PotionSplashXpSource.class)) {
            if (!this.plugin.getItemRegistry().passesFilter(item, entry.source().getItem())) continue;
            return entry;
        }
        return null;
    }
}

