/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.source;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.EnchantingXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.source.SourceLeveler;
import dev.aurelium.auraskills.common.source.SourceTypes;
import dev.aurelium.auraskills.common.user.User;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class EnchantingLeveler
extends SourceLeveler {
    public EnchantingLeveler(AuraSkills plugin) {
        super(plugin, SourceTypes.ENCHANTING);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEnchant(EnchantItemEvent event) {
        if (this.disabled()) {
            return;
        }
        Player player = event.getEnchanter();
        SkillSource<EnchantingXpSource> skillSource = this.getSource(event.getItem());
        if (skillSource == null) {
            return;
        }
        EnchantingXpSource source = skillSource.source();
        Skill skill = skillSource.skill();
        if (this.failsChecks((Cancellable)event, player, event.getEnchantBlock().getLocation(), skill)) {
            return;
        }
        User user = this.plugin.getUser(player);
        double xp = source.getXp();
        String unit = source.getUnit();
        if (unit != null) {
            if (unit.equals("{sources.units.enchant_level}")) {
                int totalLevel = event.getEnchantsToAdd().values().stream().reduce(Integer::sum).orElse(0);
                xp *= (double)totalLevel;
            } else if (unit.equals("{sources.units.exp_requirement")) {
                xp *= (double)event.getExpLevelCost();
            }
        }
        this.plugin.getLevelManager().addXp(user, skill, source, xp);
    }

    @Nullable
    private SkillSource<EnchantingXpSource> getSource(ItemStack item) {
        for (SkillSource<EnchantingXpSource> entry : this.plugin.getSkillManager().getSourcesOfType(EnchantingXpSource.class)) {
            if (!this.plugin.getItemRegistry().passesFilter(item, entry.source().getItem())) continue;
            return entry;
        }
        return null;
    }
}

