/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.source;

import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.AnvilXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.source.SourceLeveler;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.source.SourceTypes;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.evalex.EvaluationException;
import dev.aurelium.auraskills.evalex.Expression;
import dev.aurelium.auraskills.evalex.parser.ParseException;
import org.bukkit.Location;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.view.AnvilView;
import org.jetbrains.annotations.Nullable;

public class AnvilLeveler
extends SourceLeveler {
    public AnvilLeveler(AuraSkills plugin) {
        super(plugin, SourceTypes.ANVIL);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onAnvilCombine(InventoryClickEvent event) {
        Location location;
        if (this.disabled()) {
            return;
        }
        Inventory inventory = event.getClickedInventory();
        if (inventory == null) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (this.failsClickChecks(event)) {
            return;
        }
        if (!inventory.getType().equals((Object)InventoryType.ANVIL)) {
            return;
        }
        if (event.getSlot() != 2) {
            return;
        }
        User user = this.plugin.getUser(player);
        ItemStack leftItem = inventory.getItem(0);
        ItemStack rightItem = inventory.getItem(1);
        if (leftItem == null || rightItem == null) {
            return;
        }
        SkillSource<AnvilXpSource> skillSource = this.getSource(leftItem, rightItem);
        if (skillSource == null) {
            return;
        }
        AnvilXpSource source = skillSource.source();
        Skill skill = skillSource.skill();
        Location location2 = location = inventory.getLocation() != null ? inventory.getLocation() : player.getLocation();
        if (this.failsChecks((Cancellable)event, player, location, skill)) {
            return;
        }
        AnvilInventory anvil = (AnvilInventory)inventory;
        double multiplier = this.getRepairCostMultiplier(source, anvil, skill, event);
        this.plugin.getLevelManager().addXp(user, skill, source, multiplier * source.getXp());
    }

    private double getRepairCostMultiplier(AnvilXpSource source, AnvilInventory anvil, Skill skill, InventoryClickEvent event) {
        int repairCost = 1;
        if (VersionUtils.isAtLeastVersion(21, 1)) {
            InventoryView inventoryView = event.getView();
            if (inventoryView instanceof AnvilView) {
                AnvilView view = (AnvilView)inventoryView;
                repairCost = view.getRepairCost();
            }
        } else {
            repairCost = anvil.getRepairCost();
        }
        double multiplier = 1.0;
        String multiplierString = source.getMultiplier();
        if (multiplierString != null) {
            multiplierString = TextUtil.replace(multiplierString, "{repair_cost}", String.valueOf(repairCost));
            Expression expression = new Expression(multiplierString);
            try {
                multiplier = expression.evaluate().getNumberValue().doubleValue();
            }
            catch (EvaluationException | ParseException e) {
                this.plugin.logger().warn("Invalid multiplier for anvil source " + String.valueOf(source.getId()) + " in skill " + String.valueOf(skill.getId()));
                e.printStackTrace();
            }
        }
        return multiplier;
    }

    @Nullable
    private SkillSource<AnvilXpSource> getSource(ItemStack leftItem, ItemStack rightItem) {
        for (SkillSource<AnvilXpSource> entry : this.plugin.getSkillManager().getSourcesOfType(AnvilXpSource.class)) {
            AnvilXpSource source = entry.source();
            boolean leftMatches = this.plugin.getItemRegistry().passesFilter(leftItem, source.getLeftItem());
            boolean rightMatches = this.plugin.getItemRegistry().passesFilter(rightItem, source.getRightItem());
            if (!leftMatches || !rightMatches) continue;
            return entry;
        }
        return null;
    }
}

