/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.forging;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.event.skill.XpGainEvent;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ability.BukkitAbilityImpl;
import dev.aurelium.auraskills.bukkit.source.GrindstoneLeveler;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.bukkit.util.CompatUtil;
import dev.aurelium.auraskills.bukkit.util.EnchantmentValue;
import dev.aurelium.auraskills.bukkit.util.GrindstoneEnchant;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.common.user.User;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.jetbrains.annotations.Nullable;

public class ForgingAbilities
extends BukkitAbilityImpl {
    public ForgingAbilities(AuraSkills plugin) {
        super(plugin, Abilities.DISENCHANTER, Abilities.FORGER, Abilities.REPAIRING, Abilities.ANVIL_MASTER, Abilities.SKILL_MENDER);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void disenchanter(InventoryClickEvent event) {
        Abilities ability = Abilities.DISENCHANTER;
        if (event.isCancelled()) {
            return;
        }
        if (this.isDisabled(ability)) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (this.failsChecks(player, ability)) {
            return;
        }
        Inventory inventory = event.getClickedInventory();
        if (inventory == null) {
            return;
        }
        ClickType click = event.getClick();
        if (click != ClickType.LEFT && click != ClickType.RIGHT && ItemUtils.isInventoryFull(player)) {
            return;
        }
        if (event.getResult() != Event.Result.ALLOW) {
            return;
        }
        InventoryAction action = event.getAction();
        if (action != InventoryAction.PICKUP_ALL && action != InventoryAction.MOVE_TO_OTHER_INVENTORY && action != InventoryAction.PICKUP_HALF && action != InventoryAction.DROP_ALL_SLOT && action != InventoryAction.DROP_ONE_SLOT && action != InventoryAction.HOTBAR_SWAP) {
            return;
        }
        if (player.getItemOnCursor().getType() != Material.AIR && (action == InventoryAction.DROP_ALL_SLOT || action == InventoryAction.DROP_ONE_SLOT)) {
            return;
        }
        if (event.getClickedInventory().getType() != InventoryType.GRINDSTONE) {
            return;
        }
        if (event.getSlotType() != InventoryType.SlotType.RESULT) {
            return;
        }
        User user = this.plugin.getUser(player);
        Location location = inventory.getLocation();
        if (location == null) {
            return;
        }
        ItemStack first = inventory.getItem(0);
        ItemStack second = inventory.getItem(1);
        if (first != null && second != null && first.getType() != second.getType()) {
            return;
        }
        HashSet<EnchantmentValue> enchants = new HashSet<EnchantmentValue>();
        this.checkEnchants(first, enchants);
        this.checkEnchants(second, enchants);
        if (enchants.isEmpty()) {
            return;
        }
        try {
            int sum = 0;
            for (EnchantmentValue value : enchants) {
                String enchantName = value.getEnchantment().getKey().getKey().toUpperCase(Locale.ROOT);
                if (!this.containsEnchant(enchantName)) continue;
                sum += GrindstoneEnchant.valueOf(enchantName).getLevel(value.getLevel());
            }
            int average = (sum + (int)Math.ceil((double)sum / 2.0)) / 2;
            int added = (int)Math.round((double)average * (this.getValue(ability, user) / 100.0));
            World world = location.getWorld();
            if (world != null) {
                ((ExperienceOrb)world.spawn(location, ExperienceOrb.class)).setExperience(added);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkEnchants(ItemStack item, Set<EnchantmentValue> enchants) {
        if (item == null) {
            return;
        }
        for (Map.Entry entry : item.getEnchantments().entrySet()) {
            if (!this.plugin.getLevelManager().getLeveler(GrindstoneLeveler.class).isDisenchantable((Enchantment)entry.getKey())) continue;
            enchants.add(new EnchantmentValue((Enchantment)entry.getKey(), (Integer)entry.getValue()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void repairing(PrepareAnvilEvent event) {
        Abilities ability = Abilities.REPAIRING;
        if (this.isDisabled(ability)) {
            return;
        }
        Player player = this.getHighestPlayer(event.getViewers(), ability.getSkill());
        if (player == null) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        AnvilInventory inventory = event.getInventory();
        User user = this.plugin.getUser(player);
        ItemStack first = inventory.getItem(0);
        ItemStack second = inventory.getItem(1);
        ItemStack result = event.getResult();
        if (first == null || second == null || result == null) {
            return;
        }
        Material rawMaterial = this.getRawMaterial(first.getType());
        if (rawMaterial == null) {
            return;
        }
        if (second.getType() != rawMaterial) {
            return;
        }
        ItemMeta meta = first.getItemMeta();
        if (meta == null) {
            return;
        }
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            if (meta instanceof Repairable) {
                Repairable repairable = (Repairable)meta;
                short max = first.getType().getMaxDurability();
                long addedLong = (long)second.getAmount() * (Math.round(0.25 * (double)max) + Math.round((double)max * 0.25 * (this.getValue(ability, user) / 100.0)));
                short added = addedLong > 32767L ? (short)damageable.getDamage() : (addedLong < -32768L ? (short)0 : (short)addedLong);
                damageable.setDamage(Math.max(damageable.getDamage() - added, 0));
                repairable.setRepairCost(repairable.getRepairCost() * 2 + 1);
                result.setItemMeta((ItemMeta)damageable);
            }
        }
    }

    @EventHandler
    public void skillMender(XpGainEvent event) {
        Abilities ability = Abilities.SKILL_MENDER;
        if (event.isCancelled()) {
            return;
        }
        if (this.isDisabled(ability)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.failsChecks(player, ability)) {
            return;
        }
        BukkitUser user = BukkitUser.getUser(event.getUser());
        if (this.rand.nextDouble() < this.getValue(ability, user) / 100.0) {
            ItemStack offHandItem;
            ArrayList<ItemStack> mendingItems = new ArrayList<ItemStack>();
            for (ItemStack item : player.getInventory().getArmorContents()) {
                if (item == null || !item.containsEnchantment(Enchantment.MENDING) || !this.hasDamage(item)) continue;
                mendingItems.add(item);
            }
            ItemStack mainHandItem = player.getInventory().getItemInMainHand();
            if (mainHandItem.containsEnchantment(Enchantment.MENDING) && this.hasDamage(mainHandItem)) {
                mendingItems.add(mainHandItem);
            }
            if ((offHandItem = player.getInventory().getItemInOffHand()).containsEnchantment(Enchantment.MENDING) && this.hasDamage(offHandItem)) {
                mendingItems.add(offHandItem);
            }
            if (mendingItems.isEmpty()) {
                return;
            }
            ItemStack mendedItem = (ItemStack)mendingItems.get(this.rand.nextInt(mendingItems.size()));
            int durabilityToRepair = (int)Math.round(event.getAmount() / 2.0);
            ItemMeta meta = mendedItem.getItemMeta();
            if (meta == null) {
                return;
            }
            if (meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                damageable.setDamage(Math.max(damageable.getDamage() - durabilityToRepair, 0));
                mendedItem.setItemMeta((ItemMeta)damageable);
            }
        }
    }

    @Nullable
    private Material getRawMaterial(Material material) {
        String name = material.name();
        if (name.startsWith("DIAMOND_")) {
            if (!(name.equals("DIAMOND_ORE") || name.equals("DIAMOND_BLOCK") || name.equals("DIAMOND_HORSE_ARMOR"))) {
                return Material.DIAMOND;
            }
        } else if (name.startsWith("GOLD_") || name.startsWith("GOLDEN_")) {
            if (!(name.contains("APPLE") || name.contains("CARROT") || name.contains("HORSE_ARMOR") || name.contains("BLOCK") || name.contains("INGOT") || name.contains("NUGGET") || name.contains("ORE") || name.contains("BARDING"))) {
                return Material.GOLD_INGOT;
            }
        } else if (name.startsWith("IRON_")) {
            if (!(name.contains("BARS") || name.contains("DOOR") || name.contains("BLOCK") || name.contains("INGOT") || name.contains("NUGGET") || name.contains("ORE") || name.contains("TRAPDOOR") || name.contains("HORSE_ARMOR"))) {
                return Material.IRON_INGOT;
            }
        } else if (name.startsWith("LEATHER_")) {
            if (!name.contains("HORSE_ARMOR")) {
                return Material.LEATHER;
            }
        } else if (name.startsWith("NETHERITE_")) {
            if (!(name.contains("SCRAP") || name.contains("INGOT") || name.contains("BLOCK"))) {
                return Material.NETHERITE_INGOT;
            }
        } else {
            if (name.equals("TURTLE_HELMET")) {
                return CompatUtil.getTurtleScute();
            }
            if (material == Material.ELYTRA) {
                return Material.PHANTOM_MEMBRANE;
            }
            if (name.startsWith("CHAINMAIL")) {
                return Material.IRON_INGOT;
            }
        }
        return null;
    }

    @Nullable
    private Player getHighestPlayer(List<HumanEntity> viewers, Skill skill) {
        int highestLevel = 0;
        Player highestPlayer = null;
        for (HumanEntity entity : viewers) {
            Player player;
            User user;
            int level;
            if (!(entity instanceof Player) || (level = (user = this.plugin.getUser(player = (Player)entity)).getSkillLevel(skill)) <= highestLevel) continue;
            highestLevel = level;
            highestPlayer = player;
        }
        return highestPlayer;
    }

    private boolean hasDamage(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta instanceof Damageable) {
            return ((Damageable)meta).hasDamage();
        }
        return false;
    }

    private boolean containsEnchant(String enchantName) {
        for (GrindstoneEnchant grindstoneEnchant : GrindstoneEnchant.values()) {
            if (!grindstoneEnchant.toString().equals(enchantName)) continue;
            return true;
        }
        return false;
    }
}

