/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.fishing;

import dev.aurelium.auraskills.api.mana.ManaAbilities;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.mana.ManaAbilityProvider;
import dev.aurelium.auraskills.common.mana.ManaAbilityData;
import dev.aurelium.auraskills.common.message.type.ManaAbilityMessage;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public class SharpHook
extends ManaAbilityProvider {
    public SharpHook(AuraSkills plugin) {
        super(plugin, ManaAbilities.SHARP_HOOK, ManaAbilityMessage.SHARP_HOOK_USE, null);
    }

    @Override
    public void onActivate(Player player, User user) {
        if (this.manaAbility.optionBoolean("enable_sound", true)) {
            player.playSound(player.getLocation(), Sound.ENTITY_FISHING_BOBBER_RETRIEVE, 1.0f, 1.5f);
        }
    }

    @Override
    public void onStop(Player player, User user) {
    }

    @EventHandler
    public void sharpHook(PlayerInteractEvent event) {
        ProjectileSource source;
        FishHook fishHook;
        if (this.isDisabled()) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Material.FISHING_ROD) {
            return;
        }
        if (this.shouldIgnoreItem(item)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.failsChecks(player)) {
            return;
        }
        User user = this.plugin.getUser(player);
        for (Entity entity : player.getNearbyEntities(0.1, 0.1, 0.1)) {
            if (!(entity instanceof FishHook)) continue;
            fishHook = (FishHook)entity;
            source = fishHook.getShooter();
            if (!fishHook.isValid() || !(source instanceof Player) || !source.equals((Object)player)) continue;
            return;
        }
        block1: for (Entity entity : player.getNearbyEntities(33.0, 33.0, 33.0)) {
            if (!(entity instanceof FishHook)) continue;
            fishHook = (FishHook)entity;
            source = fishHook.getShooter();
            if (!fishHook.isValid() || !(source instanceof Player) || !source.equals((Object)player)) continue;
            for (Entity hooked : fishHook.getNearbyEntities(0.1, 0.1, 0.1)) {
                LivingEntity livingEntity;
                if (!(hooked instanceof LivingEntity) || (livingEntity = (LivingEntity)hooked).isDead() || !livingEntity.isValid()) continue;
                ManaAbilityData data = user.getManaAbilityData(this.manaAbility);
                int cooldown = data.getCooldown();
                if (cooldown == 0) {
                    if (!this.areValidLocations(player, livingEntity)) break block1;
                    this.activateSharpHook(player, user, livingEntity);
                    break block1;
                }
                if (data.getErrorTimer() != 0) break block1;
                Locale locale = user.getLocale();
                this.plugin.getAbilityManager().sendMessage(player, TextUtil.replace(this.plugin.getMsg(ManaAbilityMessage.NOT_READY, locale), "{cooldown}", NumberUtil.format1((double)cooldown / 20.0)));
                data.setErrorTimer(2);
                break block1;
            }
        }
    }

    private void activateSharpHook(Player player, User user, LivingEntity caught) {
        if (this.insufficientMana(user, this.getManaCost(user))) {
            return;
        }
        double damage = this.manaAbility.getValue(user.getManaAbilityLevel(this.manaAbility));
        double healthBefore = caught.getHealth();
        caught.damage(damage, (Entity)player);
        double healthAfter = caught.getHealth();
        if (!this.manaAbility.optionBoolean("disable_health_check", false) && healthBefore == healthAfter) {
            return;
        }
        this.checkActivation(player);
    }

    private boolean areValidLocations(Player damager, LivingEntity hooked) {
        Location damagerLocation = damager.getLocation();
        Location hookedLocation = hooked.getLocation();
        World damagerWorld = damagerLocation.getWorld();
        World hookedWorld = hookedLocation.getWorld();
        if (damagerWorld != null && hookedWorld != null && !damagerWorld.equals((Object)hookedWorld)) {
            return false;
        }
        return !(damagerLocation.distanceSquared(hookedLocation) > 1089.0);
    }

    @Override
    protected int getDuration(User user) {
        return 0;
    }
}

