/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.excavation;

import dev.aurelium.auraskills.api.event.mana.TerraformBlockBreakEvent;
import dev.aurelium.auraskills.api.mana.ManaAbilities;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.BlockXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.TownyHook;
import dev.aurelium.auraskills.bukkit.mana.ReadiedManaAbility;
import dev.aurelium.auraskills.bukkit.source.BlockLeveler;
import dev.aurelium.auraskills.common.message.type.ManaAbilityMessage;
import dev.aurelium.auraskills.common.source.SourceTag;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.LinkedList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class Terraform
extends ReadiedManaAbility {
    public Terraform(AuraSkills plugin) {
        super(plugin, ManaAbilities.TERRAFORM, ManaAbilityMessage.TERRAFORM_START, ManaAbilityMessage.TERRAFORM_END, new String[]{"SHOVEL"}, new Action[]{Action.RIGHT_CLICK_BLOCK, Action.RIGHT_CLICK_AIR});
    }

    @Override
    public void onActivate(Player player, User user) {
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
    }

    @Override
    public void onStop(Player player, User user) {
    }

    @Override
    public String replaceDescPlaceholders(String input, User user) {
        return TextUtil.replace(input, "{radius}", String.valueOf(4));
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        if (this.isDisabled()) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (this.failsChecks(player)) {
            return;
        }
        if (block.hasMetadata("block-ignore")) {
            return;
        }
        if (block.hasMetadata("blockbreakevent-ignore")) {
            return;
        }
        if (!block.hasMetadata("AureliumSkills-Terraform") && event.getClass() == BlockBreakEvent.class) {
            this.applyTerraform(player, this.plugin.getUser(player), block);
        }
    }

    private void applyTerraform(Player player, User user, Block block) {
        SkillSource<BlockXpSource> skillSource = this.plugin.getLevelManager().getLeveler(BlockLeveler.class).getSource(block, BlockXpSource.BlockTriggers.BREAK);
        if (skillSource == null) {
            return;
        }
        BlockXpSource source = skillSource.source();
        if (!this.plugin.getSkillManager().hasTag(source, SourceTag.TERRAFORM_APPLICABLE)) {
            return;
        }
        if (this.isActivated(user)) {
            this.terraformBreak(player, block);
            return;
        }
        if (this.isHoldingMaterial(player) && this.checkActivation(player)) {
            this.terraformBreak(player, block);
        }
    }

    private void terraformBreak(Player player, Block block) {
        Material material = block.getType();
        BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
        LinkedList<Block> toCheck = new LinkedList<Block>();
        toCheck.add(block);
        int count = 0;
        int maxCount = this.manaAbility.optionInt("max_blocks", 61);
        if (this.manaAbility.optionBoolean("max_limit_durability", false)) {
            maxCount = this.getHoldingMaterialDurability(player, maxCount);
        }
        while ((block = (Block)toCheck.poll()) != null && count < maxCount) {
            if (block.getType() != material) continue;
            block.setMetadata("AureliumSkills-Terraform", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            this.breakBlock(player, block);
            for (BlockFace face : faces) {
                toCheck.add(block.getRelative(face));
            }
            ++count;
        }
        this.setHoldingMaterialDurability(player, count, this.manaAbility.optionDouble("durability_multiplier", 0.0));
    }

    private void breakBlock(Player player, Block block) {
        if (this.plugin.getHookManager().isRegistered(TownyHook.class) && !this.plugin.getHookManager().getHook(TownyHook.class).canBreak(player, block)) {
            block.removeMetadata("AureliumSkills-Terraform", (Plugin)this.plugin);
            return;
        }
        TerraformBlockBreakEvent event = new TerraformBlockBreakEvent(block, player);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            block.breakNaturally(player.getInventory().getItemInMainHand());
        }
        block.removeMetadata("AureliumSkills-Terraform", (Plugin)this.plugin);
    }
}

