/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.enchanting;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.event.skill.XpGainEvent;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.stat.Stats;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ability.BukkitAbilityImpl;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.user.User;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.view.AnvilView;

public class EnchantingAbilities
extends BukkitAbilityImpl {
    public EnchantingAbilities(AuraSkills plugin) {
        super(plugin, Abilities.XP_CONVERT, Abilities.ENCHANTER, Abilities.XP_WARRIOR, Abilities.ENCHANTED_STRENGTH, Abilities.LUCKY_TABLE);
        this.enchantedStrength();
    }

    @EventHandler
    public void xpConvert(XpGainEvent event) {
        Abilities ability = Abilities.XP_CONVERT;
        if (this.isDisabled(ability)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.failsChecks(player, ability)) {
            return;
        }
        BukkitUser user = BukkitUser.getUser(event.getUser());
        if (!(event.getAmount() > 0.0)) {
            return;
        }
        double value = this.getValue(ability, user);
        double prevData = Math.min(user.getAbilityData(ability).getDouble("xp"), value);
        double eventAmount = event.getAmount();
        double totalXp = prevData + eventAmount;
        if (value > 0.0) {
            int added = (int)(totalXp / value);
            double remainder = totalXp - (double)added * value;
            player.giveExp(Math.max(added, 0));
            user.getAbilityData(ability).setData("xp", Math.min(remainder, value));
        }
    }

    @EventHandler
    public void xpWarrior(EntityDeathEvent event) {
        Abilities ability = Abilities.XP_WARRIOR;
        if (this.isDisabled(ability)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.getKiller() == null) {
            return;
        }
        Player player = entity.getKiller();
        if (this.failsChecks(player, ability)) {
            return;
        }
        User user = this.plugin.getUser(player);
        if (event.getDroppedExp() <= 0) {
            return;
        }
        if (this.rand.nextDouble() < this.getValue(ability, user) / 100.0) {
            event.setDroppedExp(event.getDroppedExp() * 2);
        }
    }

    private void enchantedStrength() {
        final Abilities ability = Abilities.ENCHANTED_STRENGTH;
        final String modifierName = "AbilityModifier-EnchantedStrength";
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                if (EnchantingAbilities.this.isDisabled(ability)) {
                    return;
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    User user = EnchantingAbilities.this.plugin.getUser(player);
                    ItemStack item = player.getInventory().getItemInMainHand();
                    if (!item.getEnchantments().isEmpty()) {
                        if (EnchantingAbilities.this.failsChecks(player, ability)) continue;
                        double strengthPerType = EnchantingAbilities.this.getValue(ability, user);
                        int enchantCount = 0;
                        for (Enchantment enchantment : item.getEnchantments().keySet()) {
                            if (ability.optionStringList("excluded_enchantments").contains(enchantment.getKey().getKey())) continue;
                            ++enchantCount;
                        }
                        if (enchantCount <= 0) continue;
                        StatModifier modifier = new StatModifier(modifierName, Stats.STRENGTH, strengthPerType * (double)enchantCount, AuraSkillsModifier.Operation.ADD);
                        user.addStatModifier(modifier, false);
                        continue;
                    }
                    user.removeStatModifier(modifierName);
                }
            }
        };
        this.plugin.getScheduler().timerSync(task, 50L, 500L, TimeUnit.MILLISECONDS);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void luckyTable(EnchantItemEvent event) {
        Abilities ability = Abilities.LUCKY_TABLE;
        if (event.isCancelled()) {
            return;
        }
        if (this.isDisabled(ability)) {
            return;
        }
        Player player = event.getEnchanter();
        if (this.failsChecks(player, ability)) {
            return;
        }
        User user = this.plugin.getUser(player);
        for (Map.Entry entry : event.getEnchantsToAdd().entrySet()) {
            if (((Enchantment)entry.getKey()).getMaxLevel() <= (Integer)entry.getValue() || !(this.rand.nextDouble() < this.getValue(ability, user) / 100.0)) continue;
            entry.setValue((Integer)entry.getValue() + 1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void anvilMaster(InventoryOpenEvent event) {
        Abilities ability = Abilities.ANVIL_MASTER;
        if (event.isCancelled()) {
            return;
        }
        if (this.isDisabled(ability)) {
            return;
        }
        Inventory inventory = event.getInventory();
        if (inventory.getType() != InventoryType.ANVIL || !(inventory instanceof AnvilInventory)) {
            return;
        }
        AnvilInventory anvil = (AnvilInventory)inventory;
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (this.failsChecks(player, ability)) {
            return;
        }
        User user = this.plugin.getUser(player);
        int maxCost = (int)Math.round(this.getValue(ability, user));
        if (VersionUtils.isAtLeastVersion(21, 1)) {
            InventoryView inventoryView = event.getView();
            if (inventoryView instanceof AnvilView) {
                AnvilView view = (AnvilView)inventoryView;
                view.setMaximumRepairCost(maxCost);
            }
        } else {
            anvil.setMaximumRepairCost(maxCost);
        }
    }
}

