/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.skills.agility;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.event.trait.CustomRegenEvent;
import dev.aurelium.auraskills.api.event.user.UserLoadEvent;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ability.BukkitAbilityImpl;
import dev.aurelium.auraskills.bukkit.item.BukkitPotionType;
import dev.aurelium.auraskills.bukkit.item.TraitModifiers;
import dev.aurelium.auraskills.bukkit.util.AttributeCompat;
import dev.aurelium.auraskills.bukkit.util.CompatUtil;
import dev.aurelium.auraskills.bukkit.util.PotionUtil;
import dev.aurelium.auraskills.common.message.type.AbilityMessage;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class AgilityAbilities
extends BukkitAbilityImpl {
    public AgilityAbilities(AuraSkills plugin) {
        super(plugin, Abilities.LIGHT_FALL, Abilities.JUMPER, Abilities.SUGAR_RUSH, Abilities.FLEETING, Abilities.THUNDER_FALL);
        this.startFleetingRemoveTimer();
    }

    private void lightFall(EntityDamageEvent event, User user, Player player) {
        Abilities ability = Abilities.LIGHT_FALL;
        if (this.isDisabled(ability)) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        if (!(event.getFinalDamage() > 0.0)) {
            return;
        }
        double percentReduction = this.getValue(ability, user);
        event.setDamage(event.getDamage() * (1.0 - percentReduction / 100.0));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void sugarRushSplash(PotionSplashEvent event) {
        Abilities ability = Abilities.SUGAR_RUSH;
        if (event.isCancelled()) {
            return;
        }
        if (this.isDisabled(ability)) {
            return;
        }
        for (PotionEffect effect : event.getPotion().getEffects()) {
            if (!effect.getType().equals(PotionEffectType.SPEED) && !CompatUtil.isEffect(effect.getType(), Set.of("jump_boost", "jump"))) continue;
            for (LivingEntity entity : event.getAffectedEntities()) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                if (this.failsChecks(player, ability)) {
                    return;
                }
                User user = this.plugin.getUser(player);
                if (user.getAbilityLevel(ability) <= 0) continue;
                double intensity = event.getIntensity((LivingEntity)player);
                double multiplier = 1.0 + this.getValue(ability, user) / 100.0;
                PotionUtil.applyEffect(player, new PotionEffect(effect.getType(), (int)((double)effect.getDuration() * multiplier * intensity), effect.getAmplifier()));
            }
        }
    }

    public double getSugarRushSplashMultiplier(Player player) {
        Abilities ability = Abilities.SUGAR_RUSH;
        if (this.isDisabled(ability)) {
            return 1.0;
        }
        if (this.failsChecks(player, ability)) {
            return 1.0;
        }
        User user = this.plugin.getUser(player);
        if (user.hasSkillPermission(Skills.AGILITY) && user.getAbilityLevel(ability) > 0) {
            return 1.0 + this.getValue(ability, user) / 100.0;
        }
        return 1.0;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void sugarRushDrink(PlayerItemConsumeEvent event) {
        boolean isLeaping;
        Abilities ability = Abilities.SUGAR_RUSH;
        if (event.isCancelled()) {
            return;
        }
        if (this.isDisabled(ability)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.failsChecks(player, ability)) {
            return;
        }
        User user = this.plugin.getUser(player);
        ItemStack item = event.getItem();
        if (item.getType() != Material.POTION) {
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            return;
        }
        PotionMeta meta = (PotionMeta)itemMeta;
        BukkitPotionType bukkitPotionType = new BukkitPotionType(meta);
        PotionType potionType = bukkitPotionType.getType();
        if (potionType == null) {
            return;
        }
        double multiplier = 1.0 + this.getValue(ability, user) / 100.0;
        String name = potionType.toString();
        boolean isSwiftness = name.contains("SWIFTNESS") || name.equals("SPEED");
        boolean bl = isLeaping = name.contains("LEAPING") || name.equals("JUMP");
        if (isSwiftness || isLeaping) {
            int amplifier = 0;
            if (bukkitPotionType.isUpgraded()) {
                amplifier = 1;
            }
            PotionEffectType potionEffectType = isLeaping ? PotionEffectType.SPEED : CompatUtil.jumpBoost();
            int duration = bukkitPotionType.isExtended() ? 480 : (bukkitPotionType.isUpgraded() ? 90 : 180);
            duration = (int)(multiplier * (double)duration);
            PotionUtil.applyEffect(player, new PotionEffect(potionEffectType, duration * 20, amplifier));
        }
        if (meta.hasCustomEffects()) {
            for (PotionEffect effect : meta.getCustomEffects()) {
                if (!effect.getType().equals(PotionEffectType.SPEED) && !CompatUtil.isEffect(effect.getType(), Set.of("jump_boost", "jump"))) continue;
                PotionUtil.applyEffect(player, new PotionEffect(effect.getType(), (int)((double)effect.getDuration() * multiplier), effect.getAmplifier()));
            }
        }
    }

    public void fleeting(EntityDamageEvent event, User user, Player player) {
        Abilities ability = Abilities.FLEETING;
        if (this.isDisabled(ability)) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        AttributeInstance attribute = player.getAttribute(AttributeCompat.maxHealth);
        if (attribute == null) {
            return;
        }
        double maxHealth = attribute.getValue();
        if (player.getHealth() - event.getFinalDamage() < this.getFleetingHealthRequired() * maxHealth) {
            if (user.getTraitModifier(TraitModifiers.FLEETING.getModifierId()) != null) {
                return;
            }
            double percent = this.getValue(ability, user);
            user.addTraitModifier(new TraitModifier(TraitModifiers.FLEETING.getModifierId(), Traits.MOVEMENT_SPEED, percent, AuraSkillsModifier.Operation.ADD));
            Locale locale = user.getLocale();
            this.plugin.getAbilityManager().sendMessage(player, TextUtil.replace(this.plugin.getMsg(AbilityMessage.FLEETING_START, locale), "{value}", String.valueOf((int)percent)));
        }
    }

    public void startFleetingRemoveTimer() {
        if (this.plugin.getScheduler().isFolia()) {
            this.plugin.getScheduler().timerSync(new TaskRunnable(){

                @Override
                public void run() {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        AgilityAbilities.this.plugin.getScheduler().executeAtEntity((Entity)player, task -> AgilityAbilities.this.removeFleeting(player));
                    }
                }
            }, 5L, 5L, TimeUnit.SECONDS);
        } else {
            this.plugin.getScheduler().timerSync(new TaskRunnable(){

                @Override
                public void run() {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        AgilityAbilities.this.removeFleeting(player);
                    }
                }
            }, 5L, 5L, TimeUnit.SECONDS);
        }
    }

    public void removeFleeting(Player player) {
        AttributeInstance attribute = player.getAttribute(AttributeCompat.maxHealth);
        if (attribute == null) {
            return;
        }
        double maxHealth = attribute.getValue();
        if (player.getHealth() >= this.getFleetingHealthRequired() * maxHealth) {
            this.removeFleetingMetadata(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void fleetingEnd(EntityRegainHealthEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        this.fleetingRemove((Player)event.getEntity(), event.getAmount());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void fleetingEndCustom(CustomRegenEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        this.fleetingRemove(player, event.getAmount());
    }

    private void fleetingRemove(Player player, double amountRegenerated) {
        Abilities ability = Abilities.FLEETING;
        if (this.failsChecks(player, ability)) {
            return;
        }
        AttributeInstance attribute = player.getAttribute(AttributeCompat.maxHealth);
        if (attribute == null) {
            return;
        }
        double maxHealth = attribute.getValue();
        if (player.getHealth() + amountRegenerated >= this.getFleetingHealthRequired() * maxHealth) {
            this.removeFleetingMetadata(player);
        }
    }

    private void removeFleetingMetadata(Player player) {
        User user = this.plugin.getUser(player);
        if (user.getTraitModifier(TraitModifiers.FLEETING.getModifierId()) == null) {
            return;
        }
        if (!user.removeTraitModifier(TraitModifiers.FLEETING.getModifierId())) {
            return;
        }
        Locale locale = this.plugin.getUser(player).getLocale();
        this.plugin.getAbilityManager().sendMessage(player, this.plugin.getMsg(AbilityMessage.FLEETING_END, locale));
    }

    @EventHandler
    public void fleetingLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.plugin.getUser(player).removeTraitModifier(TraitModifiers.FLEETING.getModifierId());
    }

    @EventHandler
    public void fleetingJoin(UserLoadEvent event) {
        Abilities ability = Abilities.FLEETING;
        if (this.isDisabled(ability)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.failsChecks(player, ability)) {
            return;
        }
        AttributeInstance attribute = player.getAttribute(AttributeCompat.maxHealth);
        if (attribute == null) {
            return;
        }
        if (player.getHealth() < this.getFleetingHealthRequired() * attribute.getValue()) {
            User user = this.plugin.getUser(player);
            double percent = this.getValue(ability, user);
            user.addTraitModifier(new TraitModifier(TraitModifiers.FLEETING.getModifierId(), Traits.MOVEMENT_SPEED, percent, AuraSkillsModifier.Operation.ADD));
        }
    }

    @EventHandler
    public void fleetingDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        this.plugin.getUser(player).removeTraitModifier(TraitModifiers.FLEETING.getModifierId());
    }

    private double getFleetingHealthRequired() {
        double healthPercentRequired = Abilities.FLEETING.optionDouble("health_percent_required", 20.0);
        return healthPercentRequired / 100.0;
    }

    public void thunderFall(EntityDamageEvent event, User user, Player player) {
        Abilities ability = Abilities.THUNDER_FALL;
        if (this.isDisabled(ability)) {
            return;
        }
        if (this.failsChecks(player, ability)) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        if (this.rand.nextDouble() < this.getValue(ability, user) / 100.0) {
            double percent = this.getSecondaryValue(ability, user);
            double thunderFallDamage = percent / 100.0 * event.getDamage();
            for (Entity entity : player.getWorld().getNearbyEntities(player.getLocation(), 3.0, 3.0, 1.0)) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity.equals((Object)player)) continue;
                livingEntity.damage(thunderFallDamage, (Entity)player);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void agilityListener(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.hasMetadata("NPC")) {
            return;
        }
        User user = this.plugin.getUser(player);
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            this.thunderFall(event, user, player);
            this.lightFall(event, user, player);
        }
        this.fleeting(event, user, player);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void mealSteal(EntityDamageByEntityEvent event) {
        Player enemy;
        Entity entity;
        Abilities ability;
        block12: {
            block11: {
                ability = Abilities.MEAL_STEAL;
                if (this.isDisabled(ability)) {
                    return;
                }
                if (event.isCancelled()) {
                    return;
                }
                entity = event.getEntity();
                if (!(entity instanceof Player)) break block11;
                enemy = (Player)entity;
                entity = event.getDamager();
                if (entity instanceof Player) break block12;
            }
            return;
        }
        Player player = (Player)entity;
        if (this.failsChecks(player, ability)) {
            return;
        }
        User user = this.plugin.getUser(player);
        double chance = this.getValue(ability, user) / 100.0;
        if (this.rand.nextDouble() < chance) {
            if (enemy.getFoodLevel() >= 1) {
                enemy.setFoodLevel(enemy.getFoodLevel() - 1);
            }
            if (player.getFoodLevel() < 20) {
                player.setFoodLevel(player.getFoodLevel() + 1);
            } else if (player.getSaturation() < 20.0f) {
                player.setSaturation(player.getSaturation() + 1.0f);
            }
        }
    }
}

