/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.scheduler;

import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.scheduler.BukkitTaskWrapper;
import dev.aurelium.auraskills.common.scheduler.Scheduler;
import dev.aurelium.auraskills.common.scheduler.Task;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.folialib.FoliaLib;
import dev.aurelium.auraskills.folialib.enums.EntityTaskResult;
import dev.aurelium.auraskills.folialib.wrapper.task.WrappedTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class BukkitScheduler
extends Scheduler {
    private final FoliaLib foliaLib;

    public BukkitScheduler(AuraSkills plugin) {
        super(plugin);
        this.foliaLib = new FoliaLib((Plugin)plugin);
    }

    public boolean isFolia() {
        return this.foliaLib.isFolia();
    }

    @Override
    public Task executeSync(Runnable runnable) {
        WrappedTask task = this.foliaLib.getScheduler().runLater(runnable, 1L);
        return new BukkitTaskWrapper(task);
    }

    @Override
    public Task scheduleSync(Runnable runnable, long delay, TimeUnit timeUnit) {
        WrappedTask task = this.foliaLib.getScheduler().runLater(runnable, delay, timeUnit);
        return new BukkitTaskWrapper(task);
    }

    @Override
    public Task timerSync(TaskRunnable runnable, long delay, long period, TimeUnit timeUnit) {
        WrappedTask bukkitTask = this.foliaLib.getScheduler().runTimer(runnable, delay, period, timeUnit);
        BukkitTaskWrapper task = new BukkitTaskWrapper(bukkitTask);
        runnable.injectTask(task);
        return task;
    }

    @Override
    public Task timerAsync(TaskRunnable runnable, long delay, long period, TimeUnit timeUnit) {
        WrappedTask bukkitTask = this.foliaLib.getScheduler().runTimerAsync(runnable, delay, period, timeUnit);
        BukkitTaskWrapper task = new BukkitTaskWrapper(bukkitTask);
        runnable.injectTask(task);
        return task;
    }

    public CompletableFuture<Void> executeAtLocation(Location location, Consumer<WrappedTask> consumer) {
        return this.foliaLib.getScheduler().runAtLocation(location, consumer);
    }

    public Task scheduleAtLocation(Location location, Runnable runnable, long delay, TimeUnit timeUnit) {
        WrappedTask task = this.foliaLib.getScheduler().runAtLocationLater(location, runnable, delay, timeUnit);
        return new BukkitTaskWrapper(task);
    }

    public Task timerAtLocation(Location location, Runnable runnable, long delay, long period, TimeUnit timeUnit) {
        WrappedTask task = this.foliaLib.getScheduler().runAtLocationTimer(location, runnable, delay, period, timeUnit);
        return new BukkitTaskWrapper(task);
    }

    public CompletableFuture<EntityTaskResult> executeAtEntity(Entity entity, Consumer<WrappedTask> consumer) {
        return this.foliaLib.getScheduler().runAtEntity(entity, consumer);
    }

    public Task scheduleAtEntity(Entity entity, Runnable runnable, long delay, TimeUnit timeUnit) {
        WrappedTask task = this.foliaLib.getScheduler().runAtEntityLater(entity, runnable, delay, timeUnit);
        return new BukkitTaskWrapper(task);
    }

    public Task timerAtEntity(Entity entity, Runnable runnable, long delay, long period, TimeUnit timeUnit) {
        WrappedTask task = this.foliaLib.getScheduler().runAtEntityTimer(entity, runnable, delay, period, timeUnit);
        return new BukkitTaskWrapper(task);
    }
}

