/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.requirement;

import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.requirement.RequirementNode;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EnchantmentNode
extends RequirementNode {
    private final Enchantment enchantment;
    private final int levelMin;
    private final int levelMax;

    public EnchantmentNode(AuraSkills plugin, String enchantment, int levelMin, int levelMax, String message) {
        super(plugin, message);
        NamespacedKey enchantmentKey = NamespacedKey.minecraft((String)enchantment);
        this.enchantment = enchantmentKey != null ? (Enchantment)Registry.ENCHANTMENT.get(enchantmentKey) : null;
        this.levelMin = levelMin;
        this.levelMax = levelMax;
    }

    @Override
    public boolean check(Player player) {
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (this.enchantment == null) {
            return true;
        }
        if (!(heldItem.hasItemMeta() && heldItem.getItemMeta().hasEnchants() && heldItem.getItemMeta().hasEnchant(this.enchantment))) {
            return false;
        }
        if (this.levelMin >= 0) {
            int enchantmentLevel = heldItem.getEnchantmentLevel(this.enchantment);
            if (this.levelMin == this.levelMax && enchantmentLevel != this.levelMin) {
                return false;
            }
            if (enchantmentLevel < this.levelMin) {
                return false;
            }
            if (this.levelMax >= 0 && enchantmentLevel > this.levelMax) {
                return false;
            }
        }
        return true;
    }
}

