/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.region;

import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.BlockXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.WorldGuardHook;
import dev.aurelium.auraskills.bukkit.region.BukkitRegionManager;
import dev.aurelium.auraskills.bukkit.source.BlockLeveler;
import dev.aurelium.auraskills.bukkit.util.BlockFaceUtil;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.scheduler.Task;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.world.StructureGrowEvent;

public class RegionBlockListener
implements Listener {
    private final AuraSkills plugin;
    private final BukkitRegionManager regionManager;
    private final BlockLeveler blockLeveler;

    public RegionBlockListener(AuraSkills plugin) {
        this.plugin = plugin;
        this.regionManager = plugin.getRegionManager();
        this.blockLeveler = plugin.getLevelManager().getLeveler(BlockLeveler.class);
    }

    @EventHandler
    public void checkPlace(BlockPlaceEvent event) {
        if (this.plugin.getWorldManager().isCheckReplaceDisabled(event.getBlock().getLocation())) {
            return;
        }
        if (this.plugin.getHookManager().isRegistered(WorldGuardHook.class) && this.plugin.getHookManager().getHook(WorldGuardHook.class).isInBlockedCheckRegion(event.getBlock().getLocation())) {
            return;
        }
        if (!this.plugin.configBoolean(Option.CHECK_BLOCK_REPLACE_ENABLED)) {
            return;
        }
        Block block = event.getBlock();
        this.regionManager.handleBlockPlace(block);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSandFall(EntityChangeBlockEvent event) {
        Block below;
        Block block = event.getBlock();
        if (!this.regionManager.isPlacedBlock(block)) {
            return;
        }
        Material type = block.getType();
        if (!(type != Material.SAND && type != Material.RED_SAND && type != Material.GRAVEL || (below = block.getRelative(BlockFace.DOWN)).getType() != Material.AIR && below.getType() != Material.CAVE_AIR && below.getType() != Material.VOID_AIR && below.getType() != Material.WATER && below.getType() != Material.BUBBLE_COLUMN && below.getType() != Material.LAVA)) {
            Task[] taskHolder;
            this.regionManager.removePlacedBlock(block);
            Entity entity = event.getEntity();
            AtomicInteger counter = new AtomicInteger();
            taskHolder = new Task[]{this.plugin.getScheduler().timerAtEntity(entity, () -> {
                Block currentBlock = entity.getLocation().getBlock();
                if (entity.isDead() || !entity.isValid()) {
                    if (currentBlock.getType() == type) {
                        this.regionManager.addPlacedBlock(entity.getLocation().getBlock());
                    }
                    taskHolder[0].cancel();
                } else if (currentBlock.getType().toString().contains("WEB")) {
                    taskHolder[0].cancel();
                } else if (counter.incrementAndGet() >= 200) {
                    taskHolder[0].cancel();
                }
            }, 50L, 50L, TimeUnit.MILLISECONDS)};
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void checkBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        this.regionManager.removePlacedBlock(block);
        this.checkTallPlant(block, 0, mat -> mat == Material.SUGAR_CANE);
        this.checkTallPlant(block, 0, mat -> mat == Material.BAMBOO);
        this.checkTallPlant(block, 0, mat -> mat == Material.CACTUS);
        this.checkSupportBelow(block);
        this.checkSupportSide(block);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            this.regionManager.addPlacedBlock(block.getRelative(event.getDirection()));
        }
        this.regionManager.removePlacedBlock(event.getBlock().getRelative(event.getDirection()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        Block lastBlock = event.getBlock();
        for (Block block : event.getBlocks()) {
            if (!this.regionManager.isPlacedBlock(block)) continue;
            this.regionManager.addPlacedBlock(block.getRelative(event.getDirection()));
            if (!(block.getLocation().distanceSquared(event.getBlock().getLocation()) > lastBlock.getLocation().distanceSquared(event.getBlock().getLocation()))) continue;
            lastBlock = block;
        }
        this.regionManager.removePlacedBlock(lastBlock);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        int growY = event.getLocation().getBlockY();
        for (BlockState state : event.getBlocks()) {
            if (state.getLocation().getY() != (double)growY) continue;
            this.regionManager.removePlacedBlock(state.getBlock());
        }
    }

    private void checkTallPlant(Block block, int num, Predicate<Material> isMaterial) {
        Block above;
        if (num < 20 && isMaterial.test((above = block.getRelative(BlockFace.UP)).getType()) && this.regionManager.isPlacedBlock(above)) {
            this.regionManager.removePlacedBlock(above);
            this.checkTallPlant(above, num + 1, isMaterial);
        }
    }

    private void checkSupportBelow(Block block) {
        BlockXpSource source;
        Block above = block.getRelative(BlockFace.UP);
        SkillSource<BlockXpSource> skillSource = this.blockLeveler.getSource(above, BlockXpSource.BlockTriggers.BREAK);
        BlockXpSource blockXpSource = source = skillSource == null ? null : skillSource.source();
        if (source != null && source.requiresSupportBlock(BlockXpSource.SupportBlockType.BELOW) && this.regionManager.isPlacedBlock(above)) {
            this.plugin.getScheduler().scheduleAtLocation(above.getLocation(), () -> {
                if (this.blockLeveler.isDifferentSource(above, source, BlockXpSource.BlockTriggers.BREAK)) {
                    this.regionManager.removePlacedBlock(above);
                }
            }, 50L, TimeUnit.MILLISECONDS);
        }
    }

    private void checkSupportSide(Block block) {
        for (BlockFace face : BlockFaceUtil.getBlockSides()) {
            BlockXpSource source;
            Block checkedBlock = block.getRelative(face);
            SkillSource<BlockXpSource> skillSource = this.blockLeveler.getSource(checkedBlock, BlockXpSource.BlockTriggers.BREAK);
            BlockXpSource blockXpSource = source = skillSource == null ? null : skillSource.source();
            if (source == null || !source.requiresSupportBlock(BlockXpSource.SupportBlockType.SIDE) || !this.regionManager.isPlacedBlock(checkedBlock)) continue;
            this.plugin.getScheduler().scheduleAtLocation(checkedBlock.getLocation(), () -> {
                if (this.blockLeveler.isDifferentSource(checkedBlock, source, BlockXpSource.BlockTriggers.BREAK)) {
                    this.regionManager.removePlacedBlock(checkedBlock);
                }
            }, 50L, TimeUnit.MILLISECONDS);
        }
    }
}

