/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.menus;

import dev.aurelium.auraskills.api.bukkit.BukkitTraitHandler;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.CustomStat;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.menus.shared.GlobalItems;
import dev.aurelium.auraskills.bukkit.util.ConfigurateItemParser;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import dev.aurelium.auraskills.slate.builder.MenuBuilder;
import dev.aurelium.auraskills.slate.info.TemplatePlaceholderInfo;
import dev.aurelium.auraskills.slate.item.provider.ListBuilder;
import dev.aurelium.auraskills.slate.position.PositionProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class StatsMenu {
    private final AuraSkills plugin;

    public StatsMenu(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public void build(MenuBuilder menu) {
        GlobalItems globalItems = new GlobalItems(this.plugin);
        menu.item("back", globalItems::back);
        menu.fillItem(globalItems::fill);
        menu.item("skull", item -> {
            item.replace("player", p -> p.player().getName());
            item.replace("entries", p -> {
                User user = this.plugin.getUser(p.player());
                Locale locale = user.getLocale();
                ListBuilder builder = new ListBuilder(p.data().listData());
                for (Stat stat : this.plugin.getStatManager().getEnabledStats()) {
                    String entry = p.menu().getFormat("player_stat_entry");
                    entry = TextUtil.replace(entry, "{color}", stat.getColor(locale), "{symbol}", stat.getSymbol(locale), "{stat}", stat.getDisplayName(locale, false), "{level}", this.getDisplayLevel(stat, user));
                    builder.append(entry, new String[0]);
                }
                return builder.build();
            });
            item.modify(i -> {
                ItemMeta patt0$temp = i.item().getItemMeta();
                if (patt0$temp instanceof SkullMeta) {
                    SkullMeta meta = (SkullMeta)patt0$temp;
                    meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)i.player().getUniqueId()));
                    i.item().setItemMeta((ItemMeta)meta);
                }
                return i.item();
            });
        });
        menu.template("stat", Stat.class, template -> {
            template.replace("color", p -> ((Stat)p.value()).getColor(p.locale()));
            template.replace("stat", p -> ((Stat)p.value()).getDisplayName(p.locale(), false));
            template.replace("stat_desc", p -> ((Stat)p.value()).getDescription(p.locale(), false));
            template.replace("level", p -> this.getDisplayLevel((Stat)p.value(), this.plugin.getUser(p.player())));
            template.replace("traits", this::getTraitEntries);
            template.definedContexts(m -> {
                for (Stat context : this.plugin.getStatManager().getEnabledStats()) {
                    if (!(context instanceof CustomStat)) continue;
                    CustomStat stat = (CustomStat)context;
                    try {
                        ConfigurateItemParser parser = new ConfigurateItemParser(this.plugin);
                        ConfigurationNode config = parser.parseItemContext(stat.getDefined().getItem());
                        PositionProvider provider = parser.parsePositionProvider(config, m.menu(), "stat");
                        if (provider == null) continue;
                        m.menu().setPositionProvider("stat", context, provider);
                    }
                    catch (SerializationException e) {
                        this.plugin.logger().warn("Error parsing ItemContext of CustomStat " + String.valueOf(stat.getId()));
                        e.printStackTrace();
                    }
                }
                return new HashSet<Stat>(this.plugin.getStatManager().getEnabledStats());
            });
            template.modify(t -> {
                Object patt0$temp;
                if (t.item() == null && (patt0$temp = t.value()) instanceof CustomStat) {
                    CustomStat stat = (CustomStat)patt0$temp;
                    try {
                        ConfigurateItemParser parser = new ConfigurateItemParser(this.plugin);
                        return parser.parseBaseItem(parser.parseItemContext(stat.getDefined().getItem()));
                    }
                    catch (SerializationException | IllegalArgumentException e) {
                        this.plugin.logger().warn("Error parsing ItemContext of CustomStat " + String.valueOf(stat.getId()));
                        e.printStackTrace();
                    }
                }
                return t.item();
            });
            template.onClick(c -> {
                if (this.plugin.configBoolean(Option.MENUS_STAT_INFO_ENABLED)) {
                    Map<String, Object> properties = Map.of("stat", c.value(), "previous_menu", "stats");
                    this.plugin.getSlate().openMenu(c.player(), "stat_info", properties);
                }
            });
        });
        menu.component("leveled_by", Stat.class, component -> {
            component.replace("color", p -> ((Stat)p.value()).getColor(p.locale()));
            component.replace("skills", p -> {
                Locale locale = p.locale();
                ListBuilder builder = new ListBuilder(p.data().listData());
                List<Skill> skillsLeveledBy = this.plugin.getRewardManager().getSkillsLeveledBy((Stat)p.value());
                skillsLeveledBy.forEach(s -> builder.append(s.getDisplayName(locale, false), new String[0]));
                return builder.build();
            });
            component.shouldShow(t -> !this.plugin.getRewardManager().getSkillsLeveledBy((Stat)t.value()).isEmpty());
        });
    }

    private String getTraitEntries(TemplatePlaceholderInfo<Stat> info) {
        Stat stat = info.value();
        User user = this.plugin.getUser(info.player());
        Locale locale = user.getLocale();
        ListBuilder builder = new ListBuilder(info.data().listData());
        for (Trait trait : stat.getTraits()) {
            BukkitTraitHandler impl;
            if (!trait.isEnabled() || (impl = this.plugin.getTraitManager().getTraitImpl(trait)) == null) continue;
            builder.append(info.menu().getFormat("trait_entry"), "{trait}", trait.getDisplayName(locale), "{color}", stat.getColor(locale), "{level}", impl.getMenuDisplay(user.getEffectiveTraitLevel(trait), trait, locale));
        }
        return builder.build();
    }

    private String getDisplayLevel(Stat stat, User user) {
        if (stat.hasDirectTrait() && this.plugin.configBoolean(Option.MENUS_STATS_SHOW_TRAIT_VALUES_DIRECTLY)) {
            Trait trait = stat.getTraits().get(0);
            double value = user.getEffectiveTraitLevel(trait);
            BukkitTraitHandler impl = this.plugin.getTraitManager().getTraitImpl(trait);
            if (impl != null) {
                return impl.getMenuDisplay(value, trait, user.getLocale());
            }
            return NumberUtil.format1(value);
        }
        return NumberUtil.format1(user.getStatLevel(stat));
    }
}

