/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.menus;

import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.ability.AbstractAbility;
import dev.aurelium.auraskills.api.mana.ManaAbilities;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.menus.shared.GlobalItems;
import dev.aurelium.auraskills.common.ability.AbilityUtil;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.data.DataUtil;
import dev.aurelium.auraskills.common.util.math.RomanNumber;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.slate.builder.MenuBuilder;
import dev.aurelium.auraskills.slate.function.TemplateSlot;
import dev.aurelium.auraskills.slate.inv.content.SlotPos;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AbilitiesMenu {
    private final AuraSkills plugin;

    public AbilitiesMenu(AuraSkills plugin) {
        this.plugin = plugin;
    }

    public void build(MenuBuilder menu) {
        GlobalItems globalItems = new GlobalItems(this.plugin);
        menu.item("back", globalItems::backToLevelProgression);
        menu.fillItem(globalItems::fill);
        menu.replaceTitle("skill", p -> ((Skill)p.menu().getProperty("skill")).getDisplayName(p.locale(), false));
        menu.properties(m -> Map.of("skill", m.menu().getProperty("skill", Skills.FARMING), "previous_menu", "level_progression"));
        menu.template("locked_ability", Ability.class, template -> {
            template.replace("name", p -> ((Ability)p.value()).getDisplayName(p.locale(), false));
            template.replace("desc", p -> TextUtil.replace(this.plugin.getAbilityManager().getBaseDescription((Ability)p.value(), this.plugin.getUser(p.player()), false), "{value}", NumberUtil.format1(((Ability)p.value()).getValue(1)), "{value_2}", NumberUtil.format1(((Ability)p.value()).getSecondaryValue(1)), "{chance_value}", this.plugin.getAbilityManager().getChanceValue((Ability)p.value(), 1), "{guaranteed_value}", this.plugin.getAbilityManager().getGuaranteedValue((Ability)p.value(), 1)));
            template.replace("skill", p -> ((Skill)p.menu().getProperty("skill")).getDisplayName(p.locale(), false));
            template.replace("level", p -> RomanNumber.toRoman(((Ability)p.value()).getUnlock(), this.plugin));
            template.definedContexts(m -> {
                Skill skill = (Skill)m.menu().getProperty("skill");
                User user = this.plugin.getUser(m.player());
                HashSet<Ability> lockedAbilities = new HashSet<Ability>();
                for (Ability ability : skill.getAbilities()) {
                    if (user.getAbilityLevel(ability) > 0 || !ability.isEnabled()) continue;
                    lockedAbilities.add(ability);
                }
                return lockedAbilities;
            });
            template.slotPos(this.abilitySlotPos("locked_ability"));
        });
        menu.template("unlocked_ability", Ability.class, template -> {
            template.replace("name", p -> ((Ability)p.value()).getDisplayName(p.locale(), false));
            template.definedContexts(m -> {
                Skill skill = (Skill)m.menu().getProperty("skill");
                User user = this.plugin.getUser(m.player());
                HashSet<Ability> unlockedAbilities = new HashSet<Ability>();
                for (Ability ability : skill.getAbilities()) {
                    if (user.getAbilityLevel(ability) < 1 || !ability.isEnabled()) continue;
                    unlockedAbilities.add(ability);
                }
                return unlockedAbilities;
            });
            template.slotPos(this.abilitySlotPos("unlocked_ability"));
        });
        menu.template("locked_mana_ability", ManaAbility.class, template -> {
            template.replace("name", p -> ((ManaAbility)p.value()).getDisplayName(p.locale(), false));
            template.replace("desc", p -> TextUtil.replace(this.plugin.getManaAbilityManager().getBaseDescription((ManaAbility)p.value(), this.plugin.getUser(p.player()), false), "{value}", NumberUtil.format1(((ManaAbility)p.value()).getDisplayValue(1)), "{duration}", NumberUtil.format1(this.getDuration((ManaAbility)p.value()))));
            template.replace("skill", p -> ((Skill)p.menu().getProperty("skill")).getDisplayName(p.locale(), false));
            template.replace("level", p -> RomanNumber.toRoman(((ManaAbility)p.value()).getUnlock(), this.plugin));
            template.definedContexts(m -> {
                Skill skill = (Skill)m.menu().getProperty("skill");
                ManaAbility manaAbility = skill.getManaAbility();
                HashSet<ManaAbility> locked = new HashSet<ManaAbility>();
                if (manaAbility != null && manaAbility.isEnabled() && this.plugin.getUser(m.player()).getManaAbilityLevel(manaAbility) <= 0) {
                    locked.add(manaAbility);
                }
                return locked;
            });
            template.modify(t -> ((ManaAbility)t.value()).isEnabled() ? t.item() : null);
        });
        menu.template("unlocked_mana_ability", ManaAbility.class, template -> {
            template.replace("name", p -> ((ManaAbility)p.value()).getDisplayName(p.locale(), false));
            template.definedContexts(m -> {
                Skill skill = (Skill)m.menu().getProperty("skill");
                User user = this.plugin.getUser(m.player());
                HashSet<ManaAbility> unlocked = new HashSet<ManaAbility>();
                ManaAbility manaAbility = skill.getManaAbility();
                if (manaAbility != null && manaAbility.isEnabled() && user.getManaAbilityLevel(manaAbility) >= 1) {
                    unlocked.add(manaAbility);
                }
                return unlocked;
            });
            template.modify(t -> ((ManaAbility)t.value()).isEnabled() ? t.item() : null);
        });
        menu.component("your_level", AbstractAbility.class, component -> {
            component.replace("level", p -> String.valueOf(this.plugin.getUser(p.player()).getAbstractAbilityLevel((AbstractAbility)p.value())));
            component.shouldShow(t -> this.isNotMaxed(this.plugin.getUser(t.player()), (AbstractAbility)t.value()));
        });
        menu.component("your_level_maxed", AbstractAbility.class, component -> {
            component.replace("level", p -> String.valueOf(this.plugin.getUser(p.player()).getAbstractAbilityLevel((AbstractAbility)p.value())));
            component.shouldShow(t -> !this.isNotMaxed(this.plugin.getUser(t.player()), (AbstractAbility)t.value()));
        });
        menu.component("unlocked_desc", AbstractAbility.class, component -> {
            component.replace("desc", p -> {
                User user = this.plugin.getUser(p.player());
                String format = p.menu().getFormat("desc_upgrade_value");
                Object patt0$temp = p.value();
                if (patt0$temp instanceof Ability) {
                    Ability ability = (Ability)patt0$temp;
                    int level = user.getAbilityLevel(ability);
                    String desc = this.plugin.getAbilityManager().getBaseDescription(ability, user, false);
                    return TextUtil.replace(desc, "{value}", AbilityUtil.getUpgradeValue(ability, level, format), "{value_2}", AbilityUtil.getUpgradeValue2(ability, level, format), "{chance_value}", this.plugin.getAbilityManager().getChanceValue(ability, level), "{guaranteed_value}", this.plugin.getAbilityManager().getGuaranteedValue(ability, level));
                }
                Object patt1$temp = p.value();
                if (patt1$temp instanceof ManaAbility) {
                    ManaAbility manaAbility = (ManaAbility)patt1$temp;
                    int level = user.getManaAbilityLevel(manaAbility);
                    String desc = this.plugin.getManaAbilityManager().getBaseDescription(manaAbility, user, false);
                    return TextUtil.replace(desc, "{value}", AbilityUtil.getUpgradeValue(manaAbility, level, format), "{duration}", AbilityUtil.getUpgradeDuration(manaAbility, level, format));
                }
                return null;
            });
            component.replace("skill", p -> ((AbstractAbility)p.value()).getSkill().getDisplayName(p.locale(), false));
            component.replace("level", p -> RomanNumber.toRoman(this.getNextUpgradeLevel((AbstractAbility)p.value(), this.plugin.getUser(p.player())), this.plugin));
            component.shouldShow(t -> this.isNotMaxed(this.plugin.getUser(t.player()), (AbstractAbility)t.value()));
        });
        menu.component("unlocked_desc_maxed", AbstractAbility.class, component -> {
            component.replace("desc", p -> {
                String desc;
                User user = this.plugin.getUser(p.player());
                Object patt0$temp = p.value();
                if (patt0$temp instanceof Ability) {
                    Ability ability = (Ability)patt0$temp;
                    desc = this.plugin.getAbilityManager().getBaseDescription(ability, user, false);
                    return TextUtil.replace(desc, "{value}", NumberUtil.format1(ability.getValue(user.getAbilityLevel(ability))), "{value_2}", NumberUtil.format1(ability.getSecondaryValue(user.getAbilityLevel(ability))));
                }
                Object patt1$temp = p.value();
                if (patt1$temp instanceof ManaAbility) {
                    ManaAbility manaAbility = (ManaAbility)patt1$temp;
                    desc = this.plugin.getManaAbilityManager().getBaseDescription(manaAbility, user, false);
                    return TextUtil.replace(desc, "{value}", NumberUtil.format1(manaAbility.getDisplayValue(user.getManaAbilityLevel(manaAbility))), "{duration}", NumberUtil.format1(AbilityUtil.getDuration(manaAbility, user.getManaAbilityLevel(manaAbility))));
                }
                return null;
            });
            component.shouldShow(t -> !this.isNotMaxed(this.plugin.getUser(t.player()), (AbstractAbility)t.value()));
        });
    }

    private int getNextUpgradeLevel(AbstractAbility ability, User user) {
        int unlock = ability.getUnlock();
        int levelUp = ability.getLevelUp();
        return unlock + levelUp * user.getAbstractAbilityLevel(ability);
    }

    private boolean isNotMaxed(User user, AbstractAbility ability) {
        int maxLevel = ability.getMaxLevel();
        int unlock = ability.getUnlock();
        int levelUp = ability.getLevelUp();
        int maxAllowedBySkill = (ability.getSkill().getMaxLevel() - unlock) / levelUp + 1;
        if (maxLevel == 0 || maxLevel > maxAllowedBySkill) {
            maxLevel = maxAllowedBySkill;
        }
        return user.getAbstractAbilityLevel(ability) < maxLevel;
    }

    private double getDuration(ManaAbility manaAbility) {
        if (manaAbility == ManaAbilities.LIGHTNING_BLADE) {
            return ManaAbilities.LIGHTNING_BLADE.optionDouble("base_duration", 5.0);
        }
        return manaAbility.getValue(1);
    }

    private TemplateSlot<Ability> abilitySlotPos(String itemName) {
        return t -> {
            Skill skill = (Skill)t.menu().getProperty("skill");
            Object obj = t.menu().getItemOption(itemName, "slots");
            if (obj instanceof List) {
                List<String> slots = DataUtil.castStringList(obj);
                int index = 0;
                for (Ability skillAbility : skill.getAbilities()) {
                    if (!skillAbility.isEnabled() || !skill.isEnabled()) continue;
                    if (skillAbility.equals(t.value())) break;
                    ++index;
                }
                if (slots.size() > index) {
                    String slot = slots.get(index);
                    return GlobalItems.parseSlot(slot);
                }
            }
            ArrayList<Ability> abilityList = new ArrayList<Ability>();
            for (Ability skillAbility : skill.getAbilities()) {
                if (!skillAbility.isEnabled() || !skill.isEnabled()) continue;
                abilityList.add(skillAbility);
            }
            int index = abilityList.indexOf(t.value());
            return SlotPos.of(1, 2 + index);
        };
    }
}

