/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.mana;

import dev.aurelium.auraskills.api.event.mana.ManaAbilityActivateEvent;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.mana.ManaAbilityData;
import dev.aurelium.auraskills.common.message.type.ManaAbilityMessage;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public abstract class ManaAbilityProvider
implements Listener {
    public static final String IGNORE_INTERACT_KEY = "ignore_interact";
    protected final AuraSkills plugin;
    protected final ManaAbility manaAbility;
    private final ManaAbilityMessage activateMessage;
    @Nullable
    private final ManaAbilityMessage stopMessage;

    public ManaAbilityProvider(AuraSkills plugin, ManaAbility manaAbility, ManaAbilityMessage activateMessage, @Nullable ManaAbilityMessage stopMessage) {
        this.plugin = plugin;
        this.manaAbility = manaAbility;
        this.activateMessage = activateMessage;
        this.stopMessage = stopMessage;
    }

    public ManaAbility getManaAbility() {
        return this.manaAbility;
    }

    public ManaAbilityMessage getActivateMessage() {
        return this.activateMessage;
    }

    public abstract void onActivate(Player var1, User var2);

    public abstract void onStop(Player var1, User var2);

    public String replaceDescPlaceholders(String input, User user) {
        return input;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.stop(player);
    }

    protected boolean checkActivation(Player player) {
        User user = this.plugin.getUser(player);
        ManaAbilityData data = user.getManaAbilityData(this.manaAbility);
        if (!this.isReady(user) || data.isActivated()) {
            return false;
        }
        int duration = this.getDuration(user);
        double manaCost = this.getManaCost(user);
        if (this.insufficientMana(user, manaCost)) {
            return false;
        }
        ManaAbilityActivateEvent event = new ManaAbilityActivateEvent(player, user.toApi(), this.manaAbility, duration, manaCost);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        data.setActivated(true);
        this.onActivate(player, user);
        this.consumeMana(player, user, event.getManaUsed());
        if (duration != 0) {
            this.plugin.getScheduler().scheduleSync(() -> this.stop(player), (long)duration * 50L, TimeUnit.MILLISECONDS);
        } else {
            this.stop(player);
        }
        return true;
    }

    protected void stop(Player player) {
        if (!this.plugin.getUserManager().hasUser(player.getUniqueId())) {
            return;
        }
        User user = this.plugin.getUser(player);
        ManaAbilityData data = user.getManaAbilityData(this.manaAbility);
        if (!data.isActivated()) {
            return;
        }
        data.setActivated(false);
        data.setReady(false);
        this.onStop(player, user);
        data.setCooldown(this.getCooldownTicks(user));
        if (this.stopMessage != null) {
            this.plugin.getAbilityManager().sendMessage(player, this.plugin.getMsg(this.stopMessage, user.getLocale()));
        }
    }

    protected boolean isDisabled() {
        return !this.manaAbility.isEnabled() || !this.manaAbility.getSkill().isEnabled();
    }

    protected boolean failsChecks(Player player) {
        if (this.plugin.getUser(player).getManaAbilityLevel(this.manaAbility) <= 0) {
            return true;
        }
        if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
            return true;
        }
        if (!this.plugin.getUser(player).hasSkillPermission(this.manaAbility.getSkill())) {
            return true;
        }
        if (this.plugin.configBoolean(Option.DISABLE_IN_CREATIVE_MODE)) {
            return player.getGameMode().equals((Object)GameMode.CREATIVE);
        }
        return false;
    }

    protected boolean isReady(User user) {
        return true;
    }

    protected boolean isActivated(User user) {
        return user.getManaAbilityData(this.manaAbility).isActivated();
    }

    protected double getValue(User user) {
        return this.manaAbility.getValue(user.getManaAbilityLevel(this.manaAbility));
    }

    protected int getDuration(User user) {
        return (int)Math.round(this.manaAbility.getValue(user.getManaAbilityLevel(this.manaAbility)) * 20.0);
    }

    protected void consumeMana(Player player, User user, double manaConsumed) {
        if (this.plugin.configBoolean(Option.MANA_ENABLED)) {
            user.setMana(user.getMana() - manaConsumed);
        } else {
            manaConsumed = 0.0;
        }
        this.plugin.getAbilityManager().sendMessage(player, TextUtil.replace(this.plugin.getMsg(this.activateMessage, user.getLocale()), "{mana}", NumberUtil.format0(manaConsumed)));
    }

    public boolean insufficientMana(User user, double manaCost) {
        if (user.getMana() >= manaCost || !this.plugin.configBoolean(Option.MANA_ENABLED)) {
            return false;
        }
        this.plugin.getManaAbilityManager().sendNotEnoughManaMessage(user, manaCost);
        return true;
    }

    public double getManaCost(User user) {
        return this.manaAbility.getManaCost(user.getManaAbilityLevel(this.manaAbility));
    }

    private int getCooldownTicks(User user) {
        return (int)this.manaAbility.getCooldown(user.getManaAbilityLevel(this.manaAbility)) * 20;
    }

    protected boolean shouldIgnoreItem(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, IGNORE_INTERACT_KEY);
        if (VersionUtils.isAtLeastVersion(20) && container.has(key, PersistentDataType.BOOLEAN)) {
            container.remove(key);
            container.set(key, PersistentDataType.BYTE, (Object)1);
        }
        return container.has(new NamespacedKey((Plugin)this.plugin, IGNORE_INTERACT_KEY), PersistentDataType.BYTE);
    }
}

