/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.mana;

import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.util.NumberUtil;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.mana.ManaAbilityProvider;
import dev.aurelium.auraskills.bukkit.mana.TimerCountdown;
import dev.aurelium.auraskills.bukkit.skills.archery.ChargedShot;
import dev.aurelium.auraskills.bukkit.skills.defense.Absorption;
import dev.aurelium.auraskills.bukkit.skills.excavation.Terraform;
import dev.aurelium.auraskills.bukkit.skills.farming.Replenish;
import dev.aurelium.auraskills.bukkit.skills.fighting.LightningBlade;
import dev.aurelium.auraskills.bukkit.skills.fishing.SharpHook;
import dev.aurelium.auraskills.bukkit.skills.foraging.Treecapitator;
import dev.aurelium.auraskills.bukkit.skills.mining.SpeedMine;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.common.mana.ManaAbilityManager;
import dev.aurelium.auraskills.common.message.type.ManaAbilityMessage;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class BukkitManaAbilityManager
extends ManaAbilityManager {
    private final AuraSkills plugin;
    private final Map<Class<?>, ManaAbilityProvider> providerMap;

    public BukkitManaAbilityManager(AuraSkills plugin) {
        super(plugin);
        this.plugin = plugin;
        this.providerMap = new ConcurrentHashMap();
    }

    public void registerProviders() {
        new TimerCountdown(this.plugin);
        this.registerProvider(new Replenish(this.plugin));
        this.registerProvider(new Treecapitator(this.plugin));
        this.registerProvider(new SpeedMine(this.plugin));
        this.registerProvider(new SharpHook(this.plugin));
        this.registerProvider(new Terraform(this.plugin));
        this.registerProvider(new ChargedShot(this.plugin));
        this.registerProvider(new Absorption(this.plugin));
        this.registerProvider(new LightningBlade(this.plugin));
    }

    private void registerProvider(ManaAbilityProvider provider) {
        this.providerMap.put(provider.getClass(), provider);
        Bukkit.getPluginManager().registerEvents((Listener)provider, (Plugin)this.plugin);
    }

    public <T extends ManaAbilityProvider> T getProvider(Class<T> clazz) {
        ManaAbilityProvider provider = this.providerMap.get(clazz);
        if (provider != null) {
            return (T)((ManaAbilityProvider)clazz.cast(provider));
        }
        throw new IllegalArgumentException("Mana ability provider of type " + clazz.getSimpleName() + " not found!");
    }

    @Nullable
    public ManaAbilityProvider getProvider(ManaAbility manaAbility) {
        for (ManaAbilityProvider provider : this.providerMap.values()) {
            if (!provider.getManaAbility().equals(manaAbility)) continue;
            return provider;
        }
        return null;
    }

    @Override
    public void sendNotEnoughManaMessage(User user, double manaCost) {
        Player player = ((BukkitUser)user).getPlayer();
        if (player == null) {
            return;
        }
        this.plugin.getAbilityManager().sendMessage(player, TextUtil.replace(this.plugin.getMsg(ManaAbilityMessage.NOT_ENOUGH_MANA, user.getLocale()), "{mana}", NumberUtil.format0(manaCost), "{current_mana}", String.valueOf(Math.round(user.getMana())), "{max_mana}", String.valueOf(Math.round(user.getMaxMana()))));
    }

    @Override
    public String getBaseDescription(ManaAbility manaAbility, User user, boolean formatted) {
        String desc = manaAbility.getDescription(user.getLocale(), formatted);
        ManaAbilityProvider provider = this.plugin.getManaAbilityManager().getProvider(manaAbility);
        if (provider != null) {
            desc = provider.replaceDescPlaceholders(desc, user);
        }
        return desc;
    }

    public Set<ManaAbility> getEnabledManaAbilities() {
        LinkedHashSet<ManaAbility> abilities = new LinkedHashSet<ManaAbility>();
        for (ManaAbilityProvider abilityProvider : this.providerMap.values()) {
            if (abilityProvider.isDisabled()) continue;
            abilities.add(abilityProvider.getManaAbility());
        }
        return abilities;
    }
}

