/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot.parser;

import dev.aurelium.auraskills.api.config.ConfigNode;
import dev.aurelium.auraskills.api.loot.Loot;
import dev.aurelium.auraskills.api.loot.LootParser;
import dev.aurelium.auraskills.api.loot.LootParsingContext;
import dev.aurelium.auraskills.api.loot.LootRequirements;
import dev.aurelium.auraskills.bukkit.loot.BukkitLootManager;
import dev.aurelium.auraskills.bukkit.loot.entity.EntitySupplier;
import dev.aurelium.auraskills.bukkit.loot.parser.CustomEntityParser;
import dev.aurelium.auraskills.bukkit.loot.type.EntityLoot;
import dev.aurelium.auraskills.common.api.implementation.ApiConfigNode;
import dev.aurelium.auraskills.common.util.data.Validate;
import dev.aurelium.auraskills.configurate.ConfigurationNode;

public class EntityLootParser
implements LootParser {
    protected final BukkitLootManager manager;

    public EntityLootParser(BukkitLootManager manager) {
        this.manager = manager;
    }

    @Override
    public Loot parse(LootParsingContext context, ConfigNode config, LootRequirements requirements) {
        ConfigurationNode backing = ((ApiConfigNode)config).getBacking();
        String entityType = backing.node("entity").getString();
        Validate.notNull(entityType, "Entity loot must specify an entity type");
        EntitySupplier entity = null;
        for (CustomEntityParser parser : this.manager.getCustomEntityParsers()) {
            if (!parser.shouldUseParser(backing)) continue;
            entity = parser.getEntitySupplier(backing);
            break;
        }
        Validate.notNull(entity, "Couldn't parse entity loot with entity type: " + entityType);
        return new EntityLoot(context.parseValues(config, requirements), entity);
    }
}

