/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot.handler;

import dev.aurelium.auraskills.api.event.loot.LootDropEvent;
import dev.aurelium.auraskills.api.loot.Loot;
import dev.aurelium.auraskills.api.loot.LootContext;
import dev.aurelium.auraskills.api.loot.LootPool;
import dev.aurelium.auraskills.api.loot.LootTable;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.EntityXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.loot.context.MobContext;
import dev.aurelium.auraskills.bukkit.loot.handler.LootHandler;
import dev.aurelium.auraskills.bukkit.loot.type.ItemLoot;
import dev.aurelium.auraskills.bukkit.source.EntityLeveler;
import dev.aurelium.auraskills.common.loot.CommandLoot;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.data.Pair;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.Nullable;

public class MobLootHandler
extends LootHandler
implements Listener {
    private final Random random = new Random();

    public MobLootHandler(AuraSkills plugin) {
        super(plugin);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Pair<Player, EntityXpSource.EntityDamagers> damagerPair = this.getDamager(event.getEntity().getLastDamageCause());
        if (damagerPair == null) {
            return;
        }
        Player player = damagerPair.first();
        EntityXpSource.EntityDamagers damager = damagerPair.second();
        if (this.failsChecks(player, entity.getLocation(), true)) {
            return;
        }
        User user = this.plugin.getUser(player);
        LootTable table = this.plugin.getLootManager().getLootTable(NamespacedId.fromDefault("mob"));
        if (table == null || !table.checkRequirements(player.getUniqueId())) {
            return;
        }
        EntityDamageEvent.DamageCause damageCause = this.getCause(event.getEntity().getLastDamageCause());
        EntityLeveler leveler = this.plugin.getLevelManager().getLeveler(EntityLeveler.class);
        SkillSource<EntityXpSource> skillSource = leveler.getSource(entity, damager, EntityXpSource.EntityTriggers.DEATH, damageCause);
        if (skillSource == null) {
            skillSource = leveler.getSource(entity, damager, EntityXpSource.EntityTriggers.DAMAGE, damageCause);
        }
        Skill skill = Skills.FIGHTING;
        if (skillSource != null) {
            skill = skillSource.skill();
        }
        for (LootPool pool : table.getPools()) {
            Loot selectedLoot;
            if (this.isPoolUnobtainable(pool, entity.getType()) || !pool.checkRequirements(player.getUniqueId())) continue;
            double chance = this.getCommonChance(pool, user);
            LootDropEvent.Cause cause = LootDropEvent.Cause.MOB_LOOT_TABLE;
            MobContext context = new MobContext(entity.getType());
            double rolled = this.random.nextDouble();
            if (!(rolled < chance)) continue;
            Loot loot = selectedLoot = this.selectLoot(pool, context, user);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemLoot.class, CommandLoot.class}, (Object)loot, n)) {
                case -1: {
                    break;
                }
                case 0: {
                    ItemLoot itemLoot = (ItemLoot)loot;
                    this.giveMobItemLoot(player, itemLoot, entity.getLocation(), skill, cause, table);
                    break;
                }
                case 1: {
                    CommandLoot commandLoot = (CommandLoot)loot;
                    this.giveCommandLoot(player, commandLoot, null, skill);
                    break;
                }
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPoolUnobtainable(LootPool pool, EntityType entityType) {
        Iterator<Loot> iterator = pool.getLoot().iterator();
        block2: while (true) {
            if (!iterator.hasNext()) {
                return true;
            }
            Loot loot = iterator.next();
            Set contexts = loot.getValues().getContexts().getOrDefault("mobs", Set.of());
            if (contexts.isEmpty()) {
                return false;
            }
            Iterator iterator2 = contexts.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block2;
                LootContext context = (LootContext)iterator2.next();
                if (!(context instanceof MobContext)) continue;
                MobContext mobContext = (MobContext)context;
                try {
                    // empty try
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                EntityType entityType2 = mobContext.entityType();
                EntityType type = entityType2;
                if (type.equals((Object)entityType)) break block2;
            }
            break;
        }
        return false;
    }

    @Nullable
    private Pair<Player, EntityXpSource.EntityDamagers> getDamager(EntityDamageEvent event) {
        if (event instanceof EntityDamageByEntityEvent) {
            Projectile projectile;
            ProjectileSource projectileSource;
            EntityDamageByEntityEvent entityEvent = (EntityDamageByEntityEvent)event;
            Entity damager = entityEvent.getDamager();
            if (damager instanceof Player) {
                Player player = (Player)damager;
                return new Pair<Player, EntityXpSource.EntityDamagers>(player, EntityXpSource.EntityDamagers.PLAYER);
            }
            if (damager instanceof Projectile && (projectileSource = (projectile = (Projectile)damager).getShooter()) instanceof Player) {
                Player shooter = (Player)projectileSource;
                return new Pair<Player, EntityXpSource.EntityDamagers>(shooter, EntityXpSource.EntityDamagers.PROJECTILE);
            }
        }
        return null;
    }

    private EntityDamageEvent.DamageCause getCause(EntityDamageEvent event) {
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent entityEvent = (EntityDamageByEntityEvent)event;
            return entityEvent.getCause();
        }
        return EntityDamageEvent.DamageCause.CUSTOM;
    }
}

