/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot.handler;

import dev.aurelium.auraskills.api.ability.Abilities;
import dev.aurelium.auraskills.api.event.loot.LootDropEvent;
import dev.aurelium.auraskills.api.loot.Loot;
import dev.aurelium.auraskills.api.loot.LootPool;
import dev.aurelium.auraskills.api.loot.LootTable;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.type.FishingXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.loot.handler.LootHandler;
import dev.aurelium.auraskills.bukkit.loot.type.EntityLoot;
import dev.aurelium.auraskills.bukkit.loot.type.ItemLoot;
import dev.aurelium.auraskills.bukkit.source.FishingLeveler;
import dev.aurelium.auraskills.bukkit.util.VersionUtils;
import dev.aurelium.auraskills.common.loot.CommandLoot;
import dev.aurelium.auraskills.common.loot.SourceContext;
import dev.aurelium.auraskills.common.user.User;
import java.util.Random;
import java.util.UUID;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FishingLootHandler
extends LootHandler
implements Listener {
    private final Random random = new Random();

    public FishingLootHandler(AuraSkills plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onFish(PlayerFishEvent event) {
        Player player = event.getPlayer();
        if (this.failsChecks(player, player.getLocation(), false)) {
            return;
        }
        if (!(event.getCaught() instanceof Item)) {
            return;
        }
        if (!event.getState().equals((Object)PlayerFishEvent.State.CAUGHT_FISH)) {
            return;
        }
        if (event.getExpToDrop() == 0) {
            return;
        }
        User user = this.plugin.getUser(player);
        UUID uuid = player.getUniqueId();
        ItemStack originalItem = ((Item)event.getCaught()).getItemStack();
        SkillSource<FishingXpSource> originalSource = this.plugin.getLevelManager().getLeveler(FishingLeveler.class).getSource(originalItem);
        Skill skill = originalSource != null ? originalSource.skill() : Skills.FISHING;
        LootTable table = this.plugin.getLootManager().getLootTable(skill);
        if (table == null || !table.checkRequirements(uuid)) {
            return;
        }
        for (LootPool pool : table.getPools()) {
            FishingXpSource contextSource;
            Loot selectedLoot;
            if (pool.getOption("require_open_water", Boolean.class, false).booleanValue() && VersionUtils.isAtLeastVersion(16, 5) && !event.getHook().isInOpenWater() || !pool.checkRequirements(uuid)) continue;
            FishingXpSource source = null;
            double chance = this.getCommonChance(pool, user);
            LootDropEvent.Cause cause = LootDropEvent.Cause.FISHING_OTHER_LOOT;
            if (pool.getName().equals("rare") && Abilities.TREASURE_HUNTER.isEnabled()) {
                chance = this.getAbilityModifiedChance(chance, Abilities.TREASURE_HUNTER, user);
                source = this.getSourceWithLootPool("rare", skill);
                cause = LootDropEvent.Cause.TREASURE_HUNTER;
            } else if (pool.getName().equals("epic") && Abilities.EPIC_CATCH.isEnabled()) {
                chance = this.getAbilityModifiedChance(chance, Abilities.EPIC_CATCH, user);
                source = this.getSourceWithLootPool("epic", skill);
                cause = LootDropEvent.Cause.EPIC_CATCH;
            } else if (originalSource != null) {
                source = originalSource.source();
            }
            if (source == null || this.isPoolUnobtainable(pool, source) || !(this.random.nextDouble() < chance) || (selectedLoot = this.selectLoot(pool, new SourceContext(contextSource = originalSource != null ? originalSource.source() : null), user)) == null) continue;
            if (selectedLoot instanceof ItemLoot) {
                ItemLoot itemLoot = (ItemLoot)selectedLoot;
                this.giveFishingItemLoot(player, itemLoot, event, source, skill, cause, table);
                break;
            }
            if (selectedLoot instanceof CommandLoot) {
                CommandLoot commandLoot = (CommandLoot)selectedLoot;
                this.giveFishingCommandLoot(player, commandLoot, event, source, skill);
                break;
            }
            if (!(selectedLoot instanceof EntityLoot)) break;
            EntityLoot entityLoot = (EntityLoot)selectedLoot;
            this.giveFishingEntityLoot(player, entityLoot, event, source, skill, cause);
            break;
        }
    }

    @Nullable
    private FishingXpSource getSourceWithLootPool(String lootPool, Skill skill) {
        for (SkillSource<FishingXpSource> entry : this.plugin.getSkillManager().getSourcesOfType(FishingXpSource.class)) {
            String candidate;
            if (!entry.skill().equals(skill) || (candidate = entry.source().getItem().lootPool()) == null || !lootPool.equals(candidate)) continue;
            return entry.source();
        }
        return null;
    }
}

