/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot.handler;

import dev.aurelium.auraskills.api.event.loot.LootDropEvent;
import dev.aurelium.auraskills.api.loot.Loot;
import dev.aurelium.auraskills.api.loot.LootDropCause;
import dev.aurelium.auraskills.api.loot.LootPool;
import dev.aurelium.auraskills.api.loot.LootTable;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.source.SkillSource;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.api.source.type.BlockXpSource;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.SlimefunHook;
import dev.aurelium.auraskills.bukkit.loot.handler.LootHandler;
import dev.aurelium.auraskills.bukkit.loot.type.ItemLoot;
import dev.aurelium.auraskills.bukkit.skills.excavation.ExcavationLootProvider;
import dev.aurelium.auraskills.bukkit.source.BlockLeveler;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.loot.CommandLoot;
import dev.aurelium.auraskills.common.loot.SkillLootProvider;
import dev.aurelium.auraskills.common.loot.SourceContext;
import dev.aurelium.auraskills.common.user.User;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class BlockLootHandler
extends LootHandler
implements Listener {
    private final Random random = new Random();
    private final Map<Skill, SkillLootProvider> lootProviders = new ConcurrentHashMap<Skill, SkillLootProvider>();

    public BlockLootHandler(AuraSkills plugin) {
        super(plugin);
        this.registerLootProviders();
    }

    private void registerLootProviders() {
        this.lootProviders.put(Skills.EXCAVATION, new ExcavationLootProvider(this.plugin, this));
        this.lootProviders.put(Skills.MINING, new SkillLootProvider(this, this.plugin, this){

            @Override
            public LootDropEvent.Cause getCause(LootPool pool) {
                return LootDropEvent.Cause.MINING_OTHER_LOOT;
            }
        });
        this.lootProviders.put(Skills.FORAGING, new SkillLootProvider(this, this.plugin, this){

            @Override
            public LootDropEvent.Cause getCause(LootPool pool) {
                return LootDropEvent.Cause.FORAGING_OTHER_LOOT;
            }
        });
        this.lootProviders.put(Skills.FARMING, new SkillLootProvider(this, this.plugin, this){

            @Override
            public LootDropEvent.Cause getCause(LootPool pool) {
                return LootDropEvent.Cause.FARMING_OTHER_LOOT;
            }
        });
    }

    public SkillSource<BlockXpSource> getSource(Block block) {
        return this.plugin.getLevelManager().getLeveler(BlockLeveler.class).getSource(block, BlockXpSource.BlockTriggers.BREAK);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        SkillSource<BlockXpSource> originalSource = this.getSource(block);
        if (originalSource == null) {
            return;
        }
        BlockXpSource source = originalSource.source();
        Skill skill = originalSource.skill();
        if (this.plugin.configBoolean(Option.CHECK_BLOCK_REPLACE_ENABLED) && this.plugin.getRegionManager().isPlacedBlock(block) && source.checkReplace()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.failsChecks(player, block.getLocation(), true)) {
            return;
        }
        if (this.plugin.getHookManager().isRegistered(SlimefunHook.class) && this.plugin.getHookManager().getHook(SlimefunHook.class).hasBlockInfo(block.getLocation())) {
            return;
        }
        User user = this.plugin.getUser(player);
        UUID uuid = player.getUniqueId();
        SkillLootProvider provider = this.lootProviders.get(skill);
        LootTable table = this.plugin.getLootManager().getLootTable(skill);
        if (table == null || !table.checkRequirements(uuid)) {
            return;
        }
        for (LootPool pool : table.getPools()) {
            LootDropCause cause;
            double chance;
            if (provider != null && !provider.isApplicable(pool, source) || this.isPoolUnobtainable(pool, source) || !pool.checkRequirements(uuid) || !this.selectBlockLoot(table, pool, player, chance = provider != null ? provider.getChance(pool, user) : this.getCommonChance(pool, user), source, event, skill, cause = provider != null ? provider.getCause(pool) : LootDropEvent.Cause.UNKNOWN)) continue;
            break;
        }
    }

    private boolean selectBlockLoot(LootTable table, LootPool pool, Player player, double chance, XpSource originalSource, BlockBreakEvent event, Skill skill, LootDropCause cause) {
        Loot selectedLoot;
        double rolled = this.random.nextDouble();
        if (rolled < chance && (selectedLoot = this.selectLoot(pool, new SourceContext(originalSource), this.plugin.getUser(player))) != null) {
            if (selectedLoot instanceof ItemLoot) {
                ItemLoot itemLoot = (ItemLoot)selectedLoot;
                this.giveBlockItemLoot(player, itemLoot, event, skill, cause, table);
            } else if (selectedLoot instanceof CommandLoot) {
                CommandLoot commandLoot = (CommandLoot)selectedLoot;
                this.giveCommandLoot(player, commandLoot, null, skill);
            }
            if (pool.overridesVanillaLoot()) {
                event.setDropItems(false);
            }
            return true;
        }
        return false;
    }
}

