/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.loot;

import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.loot.BukkitLootLoader;
import dev.aurelium.auraskills.bukkit.loot.ItemKeyParser;
import dev.aurelium.auraskills.bukkit.loot.context.MobContextProvider;
import dev.aurelium.auraskills.bukkit.loot.entity.VanillaEntityParser;
import dev.aurelium.auraskills.bukkit.loot.parser.CustomEntityParser;
import dev.aurelium.auraskills.bukkit.requirement.BukkitLootRequirements;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.common.AuraSkillsPlugin;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.loot.CustomItemParser;
import dev.aurelium.auraskills.common.loot.LootLoader;
import dev.aurelium.auraskills.common.loot.LootManager;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class BukkitLootManager
extends LootManager {
    private final AuraSkills plugin;
    private final LootLoader lootLoader;
    private final List<CustomItemParser> customItemParsers = new ArrayList<CustomItemParser>();
    private final List<CustomEntityParser> customEntityParsers = new ArrayList<CustomEntityParser>();

    public BukkitLootManager(AuraSkills plugin) {
        super(plugin);
        this.plugin = plugin;
        this.lootLoader = new BukkitLootLoader((AuraSkillsPlugin)plugin, this);
        this.registerContextProvider(new MobContextProvider());
        this.registerCustomItemParser(new ItemKeyParser(plugin));
        this.registerCustomEntityParser(new VanillaEntityParser(plugin));
    }

    @Override
    public AuraSkills getPlugin() {
        return this.plugin;
    }

    public void loadLootTables() {
        this.lootLoader.loadLootTables();
    }

    @Override
    public BukkitLootRequirements getLootRequirements(ConfigurationNode config) {
        return this.plugin.getRequirementManager().getLootRequirements(config);
    }

    public boolean toInventory(ItemStack held) {
        if (ItemUtils.hasTelekinesis(held)) {
            return true;
        }
        return this.plugin.configBoolean(Option.LOOT_DIRECTLY_TO_INVENTORY);
    }

    public List<CustomItemParser> getCustomItemParsers() {
        return this.customItemParsers;
    }

    public List<CustomEntityParser> getCustomEntityParsers() {
        return this.customEntityParsers;
    }

    public void registerCustomItemParser(CustomItemParser customItemParser) {
        this.customItemParsers.add(customItemParser);
    }

    public void registerCustomEntityParser(CustomEntityParser customEntityParser) {
        this.customEntityParsers.add(customEntityParser);
    }
}

