/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.listeners;

import dev.aurelium.auraskills.api.event.user.UserLoadEvent;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.ref.BukkitPlayerRef;
import dev.aurelium.auraskills.bukkit.user.BukkitUser;
import dev.aurelium.auraskills.bukkit.util.UpdateChecker;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.storage.sql.SqlStorageProvider;
import dev.aurelium.auraskills.common.user.User;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerJoinQuit
implements Listener {
    private final AuraSkills plugin;

    public PlayerJoinQuit(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getStorageProvider() instanceof SqlStorageProvider) {
            if (this.plugin.configBoolean(Option.SQL_ALWAYS_LOAD_ON_JOIN) || !this.plugin.getUserManager().hasUser(player.getUniqueId())) {
                int loadDelay = this.plugin.configInt(Option.SQL_LOAD_DELAY);
                if (loadDelay == 0) {
                    this.loadUserAsync(player);
                } else {
                    this.plugin.getScheduler().scheduleSync(() -> this.loadUserAsync(player), (long)loadDelay * 50L, TimeUnit.MILLISECONDS);
                }
            }
        } else if (!this.plugin.getUserManager().hasUser(player.getUniqueId())) {
            this.loadUserAsync(player);
        }
        this.sendUpdateMessage(player);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.getUserManager().hasUser(player.getUniqueId())) {
            return;
        }
        User user = this.plugin.getUser(player);
        this.plugin.getScheduler().executeAsync(() -> {
            try {
                this.plugin.getStorageProvider().saveSafely(user);
                this.plugin.getUserManager().removeUser(player.getUniqueId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void loadUserAsync(Player player) {
        this.plugin.getScheduler().executeAsync(() -> {
            try {
                this.plugin.getStorageProvider().load(player.getUniqueId(), BukkitPlayerRef.wrap(player));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @EventHandler
    public void onUserLoad(UserLoadEvent event) {
        this.detectUserLanguage(BukkitUser.getUser(event.getUser()), event.getPlayer());
    }

    private void detectUserLanguage(User user, Player player) {
        if (!this.plugin.configBoolean(Option.TRY_DETECT_CLIENT_LANGUAGE) || user.hasLocale()) {
            return;
        }
        try {
            Locale locale = Locale.forLanguageTag(player.getLocale().split("_")[0].toLowerCase(Locale.ROOT));
            if (this.plugin.getMessageProvider().getLoadedLanguages().contains(locale)) {
                user.setLocale(locale);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendUpdateMessage(Player player) {
        this.plugin.getScheduler().scheduleSync(() -> {
            if (!this.plugin.configBoolean(Option.CHECK_FOR_UPDATES)) {
                return;
            }
            if (!player.hasPermission("auraskills.checkupdates")) {
                return;
            }
            UpdateChecker updateChecker = new UpdateChecker(this.plugin);
            updateChecker.sendUpdateMessageAsync((CommandSender)player);
        }, 2L, TimeUnit.SECONDS);
    }
}

