/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.listeners;

import dev.aurelium.auraskills.api.damage.DamageType;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.damage.DamageHandler;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.damage.DamageResult;
import dev.aurelium.auraskills.common.user.User;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.Nullable;

public class DamageListener
implements Listener {
    private final AuraSkills plugin;
    private final DamageHandler damageHandler;

    public DamageListener(AuraSkills plugin) {
        this.plugin = plugin;
        this.damageHandler = new DamageHandler();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDamage(EntityDamageByEntityEvent event) {
        Entity entity;
        if (event.isCancelled()) {
            return;
        }
        Player player = this.getDamager(event.getDamager());
        if (player != null) {
            if (this.plugin.getWorldManager().isInDisabledWorld(player.getLocation())) {
                return;
            }
            if (player.hasMetadata("NPC")) {
                return;
            }
            if (event.getCause() == EntityDamageEvent.DamageCause.THORNS) {
                return;
            }
        }
        if ((entity = event.getEntity()) instanceof Player) {
            Player target = (Player)entity;
            if (this.plugin.getWorldManager().isInDisabledWorld(target.getLocation())) {
                return;
            }
            if (target.hasMetadata("NPC")) {
                return;
            }
        }
        if (player == null && !(event.getEntity() instanceof Player)) {
            return;
        }
        DamageResult result = this.damageHandler.handleDamage(event.getDamager(), event.getEntity(), this.getDamageType(event, player), event.getCause(), event.getDamage(), "vanilla");
        if (result.cancel()) {
            event.setCancelled(true);
        } else {
            event.setDamage(result.damage());
            Entity entity2 = event.getEntity();
            if (entity2 instanceof Player) {
                Player damaged = (Player)entity2;
                if (this.plugin.configBoolean(Option.DAMAGE_CORRECT_LAST_DAMAGE)) {
                    this.plugin.getScheduler().executeSync(() -> {
                        User user = this.plugin.getUser(damaged);
                        double lastDamage = Math.max(event.getFinalDamage(), user.getCurrentOriginalDamage());
                        damaged.setLastDamage(lastDamage);
                    });
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDamageLow(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.plugin.configBoolean(Option.DAMAGE_CORRECT_LAST_DAMAGE)) {
                User user = this.plugin.getUser(player);
                user.setCurrentOriginalDamage(event.getDamage());
            }
        }
    }

    private DamageType getDamageType(EntityDamageByEntityEvent event, Player player) {
        if (player == null) {
            return DamageType.OTHER;
        }
        if (event.getDamager() instanceof Arrow || event.getDamager() instanceof SpectralArrow || event.getDamager() instanceof TippedArrow) {
            return DamageType.BOW;
        }
        Material material = player.getInventory().getItemInMainHand().getType();
        if (material.name().contains("SWORD")) {
            return DamageType.SWORD;
        }
        if (material.name().contains("_AXE")) {
            return DamageType.AXE;
        }
        if (material.name().contains("PICKAXE")) {
            return DamageType.PICKAXE;
        }
        if (material.name().contains("SHOVEL") || material.name().contains("SPADE")) {
            return DamageType.SHOVEL;
        }
        if (material.name().contains("HOE")) {
            return DamageType.HOE;
        }
        if (material.equals((Object)Material.AIR)) {
            return DamageType.HAND;
        }
        if (event.getDamager() instanceof Trident) {
            return DamageType.BOW;
        }
        return DamageType.OTHER;
    }

    @Nullable
    private Player getDamager(Entity entity) {
        Projectile projectile;
        EntityType type;
        Player player = null;
        if (entity instanceof Player) {
            player = (Player)entity;
        } else if (entity instanceof Projectile && ((type = (projectile = (Projectile)entity).getType()) == EntityType.ARROW || type == EntityType.SPECTRAL_ARROW || type.toString().equals("TRIDENT") || type.toString().equals("TIPPED_ARROW")) && projectile.getShooter() instanceof Player) {
            player = (Player)projectile.getShooter();
        }
        return player;
    }
}

