/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.listeners;

import dev.aurelium.auraskills.api.damage.DamageMeta;
import dev.aurelium.auraskills.api.damage.DamageModifier;
import dev.aurelium.auraskills.api.event.damage.DamageEvent;
import dev.aurelium.auraskills.api.trait.Traits;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.trait.CritChanceTrait;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.user.User;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class CriticalHandler
implements Listener {
    private final AuraSkills plugin;

    public CriticalHandler(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void damageListener(DamageEvent event) {
        DamageMeta meta = event.getDamageMeta();
        Player attacker = meta.getAttackerAsPlayer();
        if (attacker != null && this.plugin.configBoolean(Option.valueOf("CRITICAL_ENABLED_" + event.getDamageMeta().getDamageType().name()))) {
            User user = this.plugin.getUser(attacker);
            meta.addAttackModifier(this.getCrit(attacker, user));
        }
    }

    private DamageModifier getCrit(Player player, User user) {
        if (!this.isCrit(user)) {
            return DamageModifier.none();
        }
        player.setMetadata("skillsCritical", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        this.plugin.getScheduler().scheduleAtEntity((Entity)player, () -> player.removeMetadata("skillsCritical", (Plugin)this.plugin), 50L, TimeUnit.MILLISECONDS);
        double value = user.getEffectiveTraitLevel(Traits.CRIT_DAMAGE) / 100.0;
        return new DamageModifier(value, DamageModifier.Operation.ADD_COMBINED);
    }

    private boolean isCrit(User user) {
        return this.plugin.getTraitManager().getTraitImpl(CritChanceTrait.class).isCrit(user);
    }
}

