/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.item;

import com.google.common.collect.Sets;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.item.ItemStateManager;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.user.User;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class ItemListener
implements Listener {
    private final AuraSkills plugin;
    private final ItemStateManager stateManager;

    public ItemListener(AuraSkills plugin) {
        this.plugin = plugin;
        this.stateManager = new ItemStateManager(plugin);
        this.scheduleTask();
    }

    public void scheduleTask() {
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    ItemStack held = player.getInventory().getItemInMainHand();
                    ItemListener.this.stateManager.changeItemInSlot(ItemListener.this.plugin.getUser(player), player, held, EquipmentSlot.HAND);
                }
            }
        };
        this.plugin.getScheduler().timerSync(task, 0L, (long)this.plugin.configInt(Option.MODIFIER_ITEM_CHECK_PERIOD) * 50L, TimeUnit.MILLISECONDS);
        this.scheduleOffHandTask();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSwap(PlayerSwapHandItemsEvent event) {
        if (!this.plugin.configBoolean(Option.MODIFIER_ITEM_ENABLE_OFF_HAND)) {
            return;
        }
        Player player = event.getPlayer();
        User user = this.plugin.getUser(player);
        Set toReload = Sets.newConcurrentHashSet();
        ItemStack itemOffHand = event.getOffHandItem();
        ItemStack itemMainHand = event.getMainHandItem();
        toReload.addAll(this.stateManager.changeItemInSlot(user, player, new ItemStack(Material.AIR), EquipmentSlot.OFF_HAND, false, false, false));
        toReload.addAll(this.stateManager.changeItemInSlot(user, player, new ItemStack(Material.AIR), EquipmentSlot.HAND, false, false, false));
        if (itemOffHand == null) {
            itemOffHand = new ItemStack(Material.AIR);
        }
        if (itemMainHand == null) {
            itemMainHand = new ItemStack(Material.AIR);
        }
        toReload.addAll(this.stateManager.changeItemInSlot(user, player, itemOffHand, EquipmentSlot.OFF_HAND, false, false, false));
        toReload.addAll(this.stateManager.changeItemInSlot(user, player, itemMainHand, EquipmentSlot.HAND, false, false, false));
        this.stateManager.reloadIdentifiers(user, toReload);
    }

    public void scheduleOffHandTask() {
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                if (!ItemListener.this.plugin.configBoolean(Option.MODIFIER_ITEM_ENABLE_OFF_HAND)) {
                    return;
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    ItemStack held = player.getInventory().getItemInOffHand();
                    ItemListener.this.stateManager.changeItemInSlot(ItemListener.this.plugin.getUser(player), player, held, EquipmentSlot.OFF_HAND);
                }
            }
        };
        this.plugin.getScheduler().timerSync(task, 0L, (long)this.plugin.configInt(Option.MODIFIER_ITEM_CHECK_PERIOD) * 50L, TimeUnit.MILLISECONDS);
    }
}

