/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.item;

import dev.aurelium.auraskills.api.stat.ReloadableIdentifier;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.item.ItemStateManager;
import dev.aurelium.auraskills.bukkit.util.armor.ArmorEquipEvent;
import dev.aurelium.auraskills.bukkit.util.armor.ArmorType;
import dev.aurelium.auraskills.common.config.Option;
import dev.aurelium.auraskills.common.scheduler.TaskRunnable;
import dev.aurelium.auraskills.common.user.User;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class ArmorModifierListener
implements Listener {
    private final AuraSkills plugin;
    private final ItemStateManager stateManager;

    public ArmorModifierListener(AuraSkills plugin) {
        this.plugin = plugin;
        this.stateManager = new ItemStateManager(plugin);
        if (plugin.configBoolean(Option.MODIFIER_ARMOR_TIMER_ENABLED)) {
            this.startTimer();
        }
    }

    @EventHandler
    public void onEquip(ArmorEquipEvent event) {
        ArmorType type;
        if (event.isCancelled()) {
            return;
        }
        if (this.plugin.configBoolean(Option.MODIFIER_ARMOR_TIMER_ENABLED)) {
            return;
        }
        Player player = event.getPlayer();
        User user = this.plugin.getUser(player);
        ItemStack newPiece = event.getNewArmorPiece();
        if (newPiece == null) {
            newPiece = new ItemStack(Material.AIR);
        }
        if ((type = event.getType()) != null) {
            this.stateManager.changeItemInSlot(user, player, newPiece, type.getEquipmentSlot());
        }
    }

    private void startTimer() {
        TaskRunnable task = new TaskRunnable(){

            @Override
            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    User user = ArmorModifierListener.this.plugin.getUser(player);
                    HashSet<ReloadableIdentifier> toReload = new HashSet<ReloadableIdentifier>();
                    for (ArmorType armorType : ArmorType.values()) {
                        ItemStack wearing = player.getInventory().getItem(armorType.getEquipmentSlot());
                        if (wearing == null) {
                            wearing = new ItemStack(Material.AIR);
                        }
                        toReload.addAll(ArmorModifierListener.this.stateManager.changeItemInSlot(user, player, wearing, armorType.getEquipmentSlot(), false, false, false));
                    }
                    ArmorModifierListener.this.stateManager.reloadIdentifiers(user, toReload);
                }
            }
        };
        this.plugin.getScheduler().timerSync(task, 0L, (long)this.plugin.configInt(Option.MODIFIER_ARMOR_TIMER_CHECK_PERIOD) * 50L, TimeUnit.MILLISECONDS);
    }
}

