/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.hooks.mythicmobs;

import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.user.User;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.events.MythicMechanicLoadEvent;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import org.bukkit.entity.Player;

@MythicMechanic(name="giveSkillXP")
public class GiveSkillXpMechanic
implements ITargetedEntitySkill {
    private final AuraSkills plugin;
    private final PlaceholderDouble xp;
    private final Skill skill;

    public GiveSkillXpMechanic(AuraSkills plugin, MythicMechanicLoadEvent loader) {
        this.plugin = plugin;
        this.xp = loader.getConfig().getPlaceholderDouble("xp", 0.0);
        this.skill = (Skill)plugin.getSkillRegistry().get(NamespacedId.fromDefault(loader.getConfig().getString(new String[]{"skill", "s"})));
    }

    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        if (this.skill == null) {
            return SkillResult.INVALID_CONFIG;
        }
        Player player = BukkitAdapter.adapt((AbstractPlayer)target.asPlayer());
        User user = this.plugin.getUser(player);
        this.plugin.getScheduler().executeSync(() -> this.plugin.getLevelManager().addXp(user, this.skill, null, this.xp.get((PlaceholderMeta)data)));
        return SkillResult.SUCCESS;
    }
}

