/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.hooks;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.hooks.WorldGuardFlags;
import dev.aurelium.auraskills.common.hooks.Hook;
import dev.aurelium.auraskills.common.hooks.HookRegistrationException;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import dev.aurelium.auraskills.configurate.ConfigurationNode;
import dev.aurelium.auraskills.configurate.serialize.SerializationException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class WorldGuardHook
extends Hook {
    private final AuraSkills plugin;
    private RegionContainer container;
    private List<String> blockedRegions;
    private List<String> blockedCheckBlockReplaceRegions;

    public WorldGuardHook(AuraSkills plugin, ConfigurationNode config) {
        super(plugin, config);
        this.plugin = plugin;
        try {
            this.loadRegions(config);
        }
        catch (SerializationException e) {
            throw new HookRegistrationException("Error serializing config list");
        }
    }

    public void loadRegions(ConfigurationNode config) throws SerializationException {
        this.container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        this.blockedRegions = new LinkedList<String>();
        this.blockedRegions.addAll(config.node("blocked_regions").getList(String.class, new ArrayList()));
        this.blockedCheckBlockReplaceRegions = new LinkedList<String>();
        this.blockedCheckBlockReplaceRegions.addAll(config.node("blocked_check_replace_regions").getList(String.class, new ArrayList()));
    }

    public boolean isBlocked(Location location, Player player, WorldGuardFlags.FlagKey flagKey) {
        if (this.isInBlockedRegion(location)) {
            return true;
        }
        return this.blockedByFlag(location, player, flagKey);
    }

    public boolean isBlocked(Location location, Player player, Skill skill) {
        if (this.isInBlockedRegion(location)) {
            return true;
        }
        if (this.blockedByFlag(location, player, WorldGuardFlags.FlagKey.XP_GAIN)) {
            return true;
        }
        return this.blockedBySkillFlag(location, player, skill);
    }

    private boolean isInBlockedRegion(Location location) {
        return this.isInRegionList(location, this.blockedRegions);
    }

    public boolean isInBlockedCheckRegion(Location location) {
        return this.isInRegionList(location, this.blockedCheckBlockReplaceRegions);
    }

    private boolean isInRegionList(Location location, List<String> blockedRegions) {
        if (location.getWorld() == null) {
            return false;
        }
        RegionManager regions = this.container.get(BukkitAdapter.adapt((World)location.getWorld()));
        if (regions == null) {
            return false;
        }
        ApplicableRegionSet set = regions.getApplicableRegions(BukkitAdapter.adapt((Location)location).toVector().toBlockPoint());
        for (ProtectedRegion region : set) {
            if (!blockedRegions.contains(region.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean blockedByFlag(Location location, Player player, WorldGuardFlags.FlagKey flagKey) {
        WorldGuardFlags flags = this.plugin.getWorldGuardFlags();
        if (flags == null) {
            return false;
        }
        StateFlag flag = flags.getStateFlag(flagKey.toString());
        return this.queryFlagState(location, player, flag);
    }

    private boolean blockedBySkillFlag(Location location, Player player, Skill skill) {
        WorldGuardFlags flags = this.plugin.getWorldGuardFlags();
        if (flags == null) {
            return false;
        }
        String flagKey = "xp-gain-" + TextUtil.replace(skill.name().toLowerCase(Locale.ROOT), "_", "-");
        StateFlag flag = flags.getStateFlag(flagKey);
        return this.queryFlagState(location, player, flag);
    }

    private boolean queryFlagState(Location location, Player player, StateFlag flag) {
        if (flag == null) {
            return false;
        }
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        RegionManager regions = this.container.get(BukkitAdapter.adapt((World)location.getWorld()));
        if (regions == null) {
            return false;
        }
        ApplicableRegionSet set = regions.getApplicableRegions(BukkitAdapter.adapt((Location)location).toVector().toBlockPoint());
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        StateFlag.State state = set.queryState((RegionAssociable)localPlayer, new StateFlag[]{flag});
        return state == StateFlag.State.DENY;
    }

    @Override
    public Class<? extends Hook> getTypeClass() {
        return WorldGuardHook.class;
    }
}

