/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.hooks;

import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.Nullable;

public class WorldGuardFlags {
    private final AuraSkills plugin;
    private final Map<String, StateFlag> stateFlags;

    public WorldGuardFlags(AuraSkills plugin) {
        this.plugin = plugin;
        this.stateFlags = new ConcurrentHashMap<String, StateFlag>();
    }

    @Nullable
    public StateFlag getStateFlag(String flagKey) {
        return this.stateFlags.get(flagKey);
    }

    public void register() {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        for (FlagKey flagKey : FlagKey.values()) {
            Object def = flagKey.getDefault();
            if (!(def instanceof Boolean)) continue;
            String flagName = "auraskills-" + TextUtil.replace(flagKey.toString().toLowerCase(Locale.ROOT), "_", "-");
            try {
                StateFlag stateFlag = new StateFlag(flagName, ((Boolean)def).booleanValue());
                registry.register((Flag)stateFlag);
                this.stateFlags.put(flagKey.toString(), stateFlag);
            }
            catch (FlagConflictException e) {
                Flag existing = registry.get(flagName);
                if (existing instanceof StateFlag) {
                    this.stateFlags.put(flagKey.toString(), (StateFlag)existing);
                    continue;
                }
                Bukkit.getLogger().warning("Could not register flag " + flagName);
                e.printStackTrace();
            }
        }
        this.registerSkillXpGainFlags(registry);
    }

    private void registerSkillXpGainFlags(FlagRegistry registry) {
        for (Skills skill : Skills.values()) {
            String skillName = TextUtil.replace(skill.getId().getKey().toLowerCase(Locale.ROOT), "_", "-");
            String flagName = "auraskills-xp-gain-" + skillName;
            String keyName = "xp-gain-" + skillName;
            try {
                StateFlag stateFlag = new StateFlag(flagName, true);
                registry.register((Flag)stateFlag);
                this.stateFlags.put(keyName, stateFlag);
            }
            catch (FlagConflictException e) {
                Flag existing = registry.get(flagName);
                if (existing instanceof StateFlag) {
                    this.stateFlags.put(keyName, (StateFlag)existing);
                    continue;
                }
                this.plugin.logger().warn("Could not register flag " + flagName);
                e.printStackTrace();
            }
        }
    }

    public static enum FlagKey {
        XP_GAIN(true),
        CUSTOM_LOOT(true);

        private final Object def;

        private FlagKey(Object def) {
            this.def = def;
        }

        public Object getDefault() {
            return this.def;
        }

        public String toString() {
            return TextUtil.replace(this.name().toLowerCase(Locale.ROOT), "_", "-");
        }
    }
}

