/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.CommandIssuer;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Description;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.config.preset.ConfigPreset;
import dev.aurelium.auraskills.common.config.preset.PresetEntry;
import dev.aurelium.auraskills.common.config.preset.PresetLoadResult;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.Locale;
import org.bukkit.ChatColor;

@CommandAlias(value="%skills_alias")
@Subcommand(value="preset")
public class PresetCommand
extends BaseCommand {
    private final AuraSkills plugin;

    public PresetCommand(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @Subcommand(value="load")
    @CommandPermission(value="auraskills.command.preset")
    @Description(value="%desc_preset_load")
    public void onLoad(CommandIssuer issuer, String file) {
        Locale locale = this.plugin.getLocale(issuer);
        try {
            ConfigPreset configPreset = this.plugin.getPresetManager().preparePreset(file);
            if (this.plugin.getConfirmManager().requiresConfirmation(issuer, file, true)) {
                issuer.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.PRESET_LOAD_CONFIRM, locale), "{entries}", this.getConfirmEntries(configPreset, locale)));
                return;
            }
            PresetLoadResult result = this.plugin.getPresetManager().loadPreset(configPreset);
            issuer.sendMessage(this.getResultEntries(result, locale));
            issuer.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.PRESET_LOAD_LOADED, locale), "{name}", file));
        }
        catch (Exception e) {
            issuer.sendMessage(String.valueOf(ChatColor.RED) + "Error loading preset: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String getConfirmEntries(ConfigPreset preset, Locale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (PresetEntry entry : preset.entries()) {
            String basePath = "commands.preset.load.";
            MessageKey key = null;
            switch (entry.action()) {
                case APPEND: {
                    key = MessageKey.of(basePath + "appended_entry");
                    break;
                }
                case MERGE: {
                    key = MessageKey.of(basePath + "merged_entry");
                    break;
                }
                case REPLACE: {
                    key = MessageKey.of(basePath + "replaced_entry");
                    break;
                }
                case DELETE: {
                    key = MessageKey.of(basePath + "deleted_entry");
                }
            }
            if (key == null) continue;
            sb.append("  ");
            sb.append(TextUtil.replace(this.plugin.getMsg(key, locale), "{file}", entry.name()));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String getResultEntries(PresetLoadResult result, Locale locale) {
        StringBuilder sb = new StringBuilder();
        if (!result.created().isEmpty()) {
            sb.append(ChatColor.GREEN);
            sb.append(this.plugin.getMsg(CommandMessage.PRESET_LOAD_CREATED, locale)).append(":\n");
            sb.append(ChatColor.WHITE);
            result.created().forEach(file -> sb.append("  ").append((String)file).append("\n"));
        }
        if (!result.modified().isEmpty()) {
            sb.append(ChatColor.YELLOW);
            sb.append(this.plugin.getMsg(CommandMessage.PRESET_LOAD_MODIFIED, locale)).append(":\n");
            sb.append(ChatColor.WHITE);
            result.created().forEach(file -> sb.append("  ").append((String)file).append("\n"));
        }
        if (!result.replaced().isEmpty()) {
            sb.append(ChatColor.RED);
            sb.append(this.plugin.getMsg(CommandMessage.PRESET_LOAD_REPLACED, locale)).append(":\n");
            sb.append(ChatColor.WHITE);
            result.created().forEach(file -> sb.append("  ").append((String)file).append("\n"));
        }
        if (!result.deleted().isEmpty()) {
            sb.append(ChatColor.DARK_RED);
            sb.append(this.plugin.getMsg(CommandMessage.PRESET_LOAD_DELETED, locale)).append(":\n");
            sb.append(ChatColor.WHITE);
            result.created().forEach(file -> sb.append("  ").append((String)file).append("\n"));
        }
        if (!result.skipped().isEmpty()) {
            sb.append(ChatColor.GOLD);
            sb.append(this.plugin.getMsg(CommandMessage.PRESET_LOAD_SKIPPED, locale)).append(":\n");
            sb.append(ChatColor.WHITE);
            result.created().forEach(file -> sb.append("  ").append((String)file).append("\n"));
        }
        return sb.toString();
    }
}

