/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.CommandIssuer;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandCompletion;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Description;
import dev.aurelium.auraskills.acf.annotation.Flags;
import dev.aurelium.auraskills.acf.annotation.Optional;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.common.message.MessageBuilder;
import dev.aurelium.auraskills.common.message.MessageKey;
import dev.aurelium.auraskills.common.message.type.ACFCoreMessage;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.user.User;
import java.util.Locale;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

@CommandAlias(value="%skills_alias")
@Subcommand(value="jobs")
public class JobsCommand
extends BaseCommand {
    private final AuraSkills plugin;

    public JobsCommand(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @Subcommand(value="add")
    @CommandCompletion(value="@skills @players")
    @CommandPermission(value="auraskills.command.jobs")
    @Description(value="%desc_jobs_add")
    public void onAddOther(CommandIssuer issuer, Skill job, @Flags(value="other") @CommandPermission(value="auraskills.command.jobs.other") @Optional User user) {
        Locale locale = this.plugin.getLocale(issuer);
        if (user == null) {
            if (issuer.isPlayer()) {
                Player player = (Player)issuer.getIssuer();
                this.addJobToPlayer(this.plugin.getUser(player), job, locale, issuer);
            } else {
                issuer.sendMessage(this.plugin.getMsg(ACFCoreMessage.NOT_ALLOWED_ON_CONSOLE, locale));
            }
        } else {
            this.addJobToPlayer(user, job, locale, issuer);
        }
    }

    private void addJobToPlayer(User user, Skill job, Locale locale, CommandIssuer issuer) {
        if (user.getJobs().size() < user.getJobLimit()) {
            if (!user.getJobs().contains(job)) {
                user.addJob(job);
                MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.JOBS_ADD_ADDED, "player", user.getUsername(), "job", job.getDisplayName(locale) + String.valueOf(ChatColor.RESET)).send(issuer);
            } else {
                MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.JOBS_ADD_EXISTING, "player", user.getUsername(), "job", job.getDisplayName(locale) + String.valueOf(ChatColor.RESET)).send(issuer);
            }
        } else {
            MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.JOBS_ADD_LIMITED, "player", user.getUsername()).send(issuer);
        }
    }

    @Subcommand(value="remove")
    @CommandCompletion(value="@skills @players")
    @CommandPermission(value="auraskills.command.jobs")
    @Description(value="%desc_jobs_remove")
    public void onRemove(CommandIssuer issuer, Skill job, @Flags(value="other") @CommandPermission(value="auraskills.command.jobs.other") @Optional User user) {
        Locale locale = this.plugin.getLocale(issuer);
        if (user == null) {
            if (issuer.isPlayer()) {
                Player player = (Player)issuer.getIssuer();
                this.removeJobFromPlayer(this.plugin.getUser(player), job, locale, issuer);
            } else {
                issuer.sendMessage(this.plugin.getMsg(ACFCoreMessage.NOT_ALLOWED_ON_CONSOLE, locale));
            }
        } else {
            this.removeJobFromPlayer(user, job, locale, issuer);
        }
    }

    private void removeJobFromPlayer(User user, Skill job, Locale locale, CommandIssuer issuer) {
        if (user.getJobs().contains(job)) {
            user.removeJob(job);
            MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.JOBS_REMOVE_REMOVED, "player", user.getUsername(), "job", job.getDisplayName(locale) + String.valueOf(ChatColor.RESET)).send(issuer);
        } else {
            MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.JOBS_REMOVE_UNCHANGED, "player", user.getUsername(), "job", job.getDisplayName(locale) + String.valueOf(ChatColor.RESET)).send(issuer);
        }
    }

    @Subcommand(value="removeall")
    @CommandCompletion(value="@players")
    @CommandPermission(value="auraskills.command.jobs")
    @Description(value="%desc_jobs_removeall")
    public void onRemoveAll(CommandIssuer issuer, @Flags(value="other") @CommandPermission(value="auraskills.command.jobs.other") @Optional User user) {
        Locale locale = this.plugin.getLocale(issuer);
        if (user == null) {
            if (issuer.isPlayer()) {
                Player player = (Player)issuer.getIssuer();
                this.removeAllJobs(this.plugin.getUser(player), locale, issuer);
            }
        } else {
            this.removeAllJobs(user, locale, issuer);
        }
    }

    private void removeAllJobs(User user, Locale locale, CommandIssuer issuer) {
        user.clearAllJobs();
        MessageBuilder.create(this.plugin).locale(locale).prefix().message((MessageKey)CommandMessage.JOBS_REMOVEALL_REMOVED, "player", user.getUsername()).send(issuer);
    }
}

