/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.commands;

import dev.aurelium.auraskills.acf.BaseCommand;
import dev.aurelium.auraskills.acf.InvalidCommandArgument;
import dev.aurelium.auraskills.acf.annotation.CommandAlias;
import dev.aurelium.auraskills.acf.annotation.CommandCompletion;
import dev.aurelium.auraskills.acf.annotation.CommandPermission;
import dev.aurelium.auraskills.acf.annotation.Default;
import dev.aurelium.auraskills.acf.annotation.Description;
import dev.aurelium.auraskills.acf.annotation.Flags;
import dev.aurelium.auraskills.acf.annotation.Subcommand;
import dev.aurelium.auraskills.api.item.ModifierType;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Multiplier;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.trait.Trait;
import dev.aurelium.auraskills.api.trait.TraitModifier;
import dev.aurelium.auraskills.api.util.AuraSkillsModifier;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.item.SkillsItem;
import dev.aurelium.auraskills.bukkit.stat.StatFormat;
import dev.aurelium.auraskills.bukkit.util.ItemUtils;
import dev.aurelium.auraskills.common.message.type.CommandMessage;
import dev.aurelium.auraskills.common.message.type.LevelerMessage;
import dev.aurelium.auraskills.common.user.User;
import dev.aurelium.auraskills.common.util.data.KeyIntPair;
import dev.aurelium.auraskills.common.util.text.TextUtil;
import java.util.Locale;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@CommandAlias(value="%skills_alias")
@Subcommand(value="item")
public class ItemCommand
extends BaseCommand {
    private final AuraSkills plugin;
    private final StatFormat format;

    public ItemCommand(AuraSkills plugin) {
        this.plugin = plugin;
        this.format = new StatFormat(plugin);
    }

    @Subcommand(value="modifier add")
    @CommandCompletion(value="@stats @nothing @modifier_operations false|true")
    @CommandPermission(value="auraskills.command.item.modifier")
    @Description(value="%desc_item_modifier_add")
    public void onItemModifierAdd(@Flags(value="itemheld") Player player, Stat stat, double value, @Default(value="add") AuraSkillsModifier.Operation operation, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (StatModifier statModifier : skillsItem.getStatModifiers(ModifierType.ITEM)) {
            if (statModifier.stat() != stat) continue;
            player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ITEM_MODIFIER_ADD_ALREADY_EXISTS, locale), stat, locale));
            return;
        }
        if (lore) {
            skillsItem.addModifierLore(ModifierType.ITEM, stat, value, operation, locale);
        }
        skillsItem.addModifier(SkillsItem.MetaType.MODIFIER, ModifierType.ITEM, stat, value, operation);
        ItemStack newItem = skillsItem.getItem();
        player.getInventory().setItemInMainHand(newItem);
        player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ITEM_MODIFIER_ADD_ADDED, locale), stat, value, operation, locale));
    }

    @Subcommand(value="modifier remove")
    @CommandCompletion(value="@stats false|true")
    @CommandPermission(value="auraskills.command.item.modifier")
    @Description(value="%desc_item_modifier_remove")
    public void onItemModifierRemove(@Flags(value="itemheld") Player player, Stat stat, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        boolean removed = false;
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (StatModifier modifier : skillsItem.getStatModifiers(ModifierType.ITEM)) {
            if (modifier.stat() != stat) continue;
            skillsItem.removeModifier(SkillsItem.MetaType.MODIFIER, ModifierType.ITEM, stat);
            removed = true;
            break;
        }
        if (lore) {
            skillsItem.removeModifierLore(stat, locale);
        }
        item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        if (removed) {
            player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ITEM_MODIFIER_REMOVE_REMOVED, locale), stat, locale));
        } else {
            player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ITEM_MODIFIER_REMOVE_DOES_NOT_EXIST, locale), stat, locale));
        }
    }

    @Subcommand(value="modifier list")
    @CommandPermission(value="auraskills.command.item.modifier")
    @Description(value="%desc_item_modifier_list")
    public void onItemModifierList(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        StringBuilder message = new StringBuilder(this.plugin.getMsg(CommandMessage.ITEM_MODIFIER_LIST_HEADER, locale));
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (StatModifier modifier : skillsItem.getStatModifiers(ModifierType.ITEM)) {
            message.append("\n").append(this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ITEM_MODIFIER_LIST_ENTRY, locale), modifier, locale));
        }
        player.sendMessage(message.toString());
    }

    @Subcommand(value="modifier removeall")
    @CommandPermission(value="auraskills.command.item.modifier")
    @Description(value="%desc_item_modifier_removeall")
    public void onItemModifierRemoveAll(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.removeAll(SkillsItem.MetaType.MODIFIER, ModifierType.ITEM);
        item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.ITEM_MODIFIER_REMOVEALL_REMOVED, locale));
    }

    @Subcommand(value="trait add")
    @CommandCompletion(value="@traits @nothing @modifier_operations false|true")
    @CommandPermission(value="auraskills.command.item.modifier")
    @Description(value="%desc_item_trait_add")
    public void onItemTraitAdd(@Flags(value="itemheld") Player player, Trait trait, double value, @Default(value="add") AuraSkillsModifier.Operation operation, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (TraitModifier modifier : skillsItem.getTraitModifiers(ModifierType.ITEM)) {
            if (!modifier.trait().equals(trait)) continue;
            player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ITEM_TRAIT_ADD_ALREADY_EXISTS, locale), trait, locale));
            return;
        }
        if (lore) {
            skillsItem.addModifierLore(ModifierType.ITEM, trait, value, operation, locale);
        }
        skillsItem.addModifier(SkillsItem.MetaType.TRAIT_MODIFIER, ModifierType.ITEM, trait, value, operation);
        ItemStack newItem = skillsItem.getItem();
        player.getInventory().setItemInMainHand(newItem);
        player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ITEM_TRAIT_ADD_ADDED, locale), trait, value, operation, locale));
    }

    @Subcommand(value="trait remove")
    @CommandCompletion(value="@traits")
    @CommandPermission(value="auraskills.command.item.modifier")
    @Description(value="%desc_item_trait_remove")
    public void onItemTraitRemove(@Flags(value="itemheld") Player player, Trait trait) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        boolean removed = false;
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (TraitModifier modifier : skillsItem.getTraitModifiers(ModifierType.ITEM)) {
            if (!modifier.trait().equals(trait)) continue;
            skillsItem.removeModifier(SkillsItem.MetaType.TRAIT_MODIFIER, ModifierType.ITEM, trait);
            removed = true;
            break;
        }
        item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        if (removed) {
            player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ITEM_MODIFIER_REMOVE_REMOVED, locale), trait, locale));
        } else {
            player.sendMessage(this.plugin.getPrefix(locale) + this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ITEM_MODIFIER_REMOVE_DOES_NOT_EXIST, locale), trait, locale));
        }
    }

    @Subcommand(value="trait list")
    @CommandPermission(value="auraskills.command.item.modifier")
    @Description(value="%desc_item_trait_list")
    public void onItemTraitList(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        StringBuilder message = new StringBuilder(this.plugin.getMsg(CommandMessage.ITEM_MODIFIER_LIST_HEADER, locale));
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (TraitModifier modifier : skillsItem.getTraitModifiers(ModifierType.ITEM)) {
            message.append("\n").append(this.format.applyPlaceholders(this.plugin.getMsg(CommandMessage.ITEM_MODIFIER_LIST_ENTRY, locale), modifier, locale));
        }
        player.sendMessage(message.toString());
    }

    @Subcommand(value="trait removeall")
    @CommandPermission(value="auraskills.command.item.modifier")
    @Description(value="%desc_item_trait_removeall")
    public void onItemTraitRemoveAll(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.removeAll(SkillsItem.MetaType.TRAIT_MODIFIER, ModifierType.ITEM);
        item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.ITEM_MODIFIER_REMOVEALL_REMOVED, locale));
    }

    @Subcommand(value="requirement add")
    @CommandPermission(value="auraskills.command.item.requirement")
    @CommandCompletion(value="@skills @nothing false|true")
    @Description(value="%desc_item_requirement_add")
    public void onItemRequirementAdd(@Flags(value="itemheld") Player player, Skill skill, int level, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        if (skillsItem.getRequirements(ModifierType.ITEM).containsKey(skill)) {
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_REQUIREMENT_ADD_ALREADY_EXISTS, locale), "{skill}", skill.getDisplayName(locale)));
            return;
        }
        skillsItem.addRequirement(ModifierType.ITEM, skill, level);
        if (lore) {
            skillsItem.addRequirementLore(ModifierType.ITEM, skill, level, locale);
        }
        item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_REQUIREMENT_ADD_ADDED, locale), "{skill}", skill.getDisplayName(locale), "{level}", String.valueOf(level)));
    }

    @Subcommand(value="requirement remove")
    @CommandPermission(value="auraskills.command.item.requirement")
    @CommandCompletion(value="@skills false|true")
    @Description(value="%desc_item_requirement_remove")
    public void onItemRequirementRemove(@Flags(value="itemheld") Player player, Skill skill, @Default(value="true") boolean lore) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        if (skillsItem.getRequirements(ModifierType.ITEM).containsKey(skill)) {
            skillsItem.removeRequirement(ModifierType.ITEM, skill);
            if (lore) {
                skillsItem.removeRequirementLore(skill);
            }
            item = skillsItem.getItem();
            player.getInventory().setItemInMainHand(item);
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_REQUIREMENT_REMOVE_REMOVED, locale), "{skill}", skill.getDisplayName(locale)));
        } else {
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_REQUIREMENT_REMOVE_DOES_NOT_EXIST, locale), "{skill}", skill.getDisplayName(locale)));
        }
    }

    @Subcommand(value="requirement list")
    @CommandPermission(value="auraskills.command.item.requirement")
    @Description(value="%desc_item_requirement_list")
    public void onItemRequirementList(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        player.sendMessage(this.plugin.getMsg(CommandMessage.ITEM_REQUIREMENT_LIST_HEADER, locale));
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (Map.Entry<Skill, Integer> entry : skillsItem.getRequirements(ModifierType.ITEM).entrySet()) {
            player.sendMessage(TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_REQUIREMENT_LIST_ENTRY, locale), "{skill}", entry.getKey().getDisplayName(locale), "{level}", String.valueOf(entry.getValue())));
        }
    }

    @Subcommand(value="requirement removeall")
    @CommandPermission(value="auraskills.command.item.requirement")
    @Description(value="%desc_item_requirement_removeall")
    public void onItemRequirementRemoveAll(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.removeAll(SkillsItem.MetaType.REQUIREMENT, ModifierType.ITEM);
        item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.ITEM_REQUIREMENT_REMOVEALL_REMOVED, locale));
    }

    @Subcommand(value="register")
    @CommandPermission(value="auraskills.command.item.register")
    @Description(value="%desc_item_register")
    public void onItemRegister(@Flags(value="itemheld") Player player, String key) {
        Locale locale = this.plugin.getUser(player).getLocale();
        if (key.contains(" ")) {
            player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.ITEM_REGISTER_NO_SPACES, locale));
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (this.plugin.getItemRegistry().getItem(NamespacedId.fromDefault(key)) == null) {
            this.plugin.getItemRegistry().register(NamespacedId.fromDefault(key), item);
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_REGISTER_REGISTERED, locale), "{key}", key));
        } else {
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_REGISTER_ALREADY_REGISTERED, locale), "{key}", key));
        }
    }

    @Subcommand(value="unregister")
    @CommandPermission(value="auraskills.command.item.register")
    @CommandCompletion(value="@item_keys")
    @Description(value="%desc_item_unregister")
    public void onItemUnregister(Player player, String key) {
        Locale locale = this.plugin.getUser(player).getLocale();
        if (this.plugin.getItemRegistry().getItem(NamespacedId.fromDefault(key)) != null) {
            this.plugin.getItemRegistry().unregister(NamespacedId.fromDefault(key));
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_UNREGISTER_UNREGISTERED, locale), "{key}", key));
        } else {
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_UNREGISTER_NOT_REGISTERED, locale), "{key}", key));
        }
    }

    @Subcommand(value="give")
    @CommandPermission(value="auraskills.command.item.give")
    @CommandCompletion(value="@players @item_keys")
    @Description(value="%desc_item_give")
    public void onItemGive(CommandSender sender, @Flags(value="other") Player player, String key, @Default(value="-1") int amount) {
        ItemStack item = this.plugin.getItemRegistry().getItem(NamespacedId.fromDefault(key));
        Locale locale = this.plugin.getLocale(sender);
        if (item != null) {
            if (amount != -1) {
                item.setAmount(amount);
            }
            this.plugin.getScheduler().executeAtEntity((Entity)player, task -> {
                String message;
                ItemStack leftoverItem = ItemUtils.addItemToInventory(player, item);
                String senderMsg = TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_GIVE_SENDER, locale), "{amount}", String.valueOf(item.getAmount()), "{key}", key, "{player}", player.getName());
                if (!senderMsg.isEmpty()) {
                    sender.sendMessage(this.plugin.getPrefix(locale) + senderMsg);
                }
                if (!sender.equals((Object)player) && !(message = TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_GIVE_RECEIVER, locale), "{amount}", String.valueOf(item.getAmount()), "{key}", key)).isEmpty()) {
                    player.sendMessage(this.plugin.getPrefix(locale) + message);
                }
                if (leftoverItem != null) {
                    User user = this.plugin.getUser(player);
                    user.getUnclaimedItems().add(new KeyIntPair(key, leftoverItem.getAmount()));
                    String message2 = this.plugin.getMsg(LevelerMessage.UNCLAIMED_ITEM, locale);
                    if (!message2.isEmpty()) {
                        player.sendMessage(this.plugin.getPrefix(locale) + message2);
                    }
                }
            });
        } else {
            sender.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_UNREGISTER_NOT_REGISTERED, locale), "{key}", key));
        }
    }

    @Subcommand(value="multiplier add")
    @CommandCompletion(value="@skills_global @nothing true|false")
    @CommandPermission(value="auraskills.command.item.multiplier")
    @Description(value="%desc_item_multiplier_add")
    public void onItemMultiplierAdd(@Flags(value="itemheld") Player player, String target, double value, @Default(value="true") boolean lore) {
        ItemStack item = player.getInventory().getItemInMainHand();
        Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(target));
        Locale locale = this.plugin.getUser(player).getLocale();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        if (skill != null) {
            for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ITEM)) {
                if (multiplier.skill() != skill) continue;
                player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_MULTIPLIER_ADD_ALREADY_EXISTS, locale), "{target}", skill.getDisplayName(locale)));
                return;
            }
            if (lore) {
                skillsItem.addMultiplierLore(ModifierType.ITEM, skill, value, locale);
            }
            skillsItem.addMultiplier(ModifierType.ITEM, skill, value);
            ItemStack newItem = skillsItem.getItem();
            player.getInventory().setItemInMainHand(newItem);
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_MULTIPLIER_ADD_ADDED, locale), "{target}", skill.getDisplayName(locale), "{value}", String.valueOf(value)));
        } else if (target.equalsIgnoreCase("global")) {
            String global = this.plugin.getMsg(CommandMessage.MULTIPLIER_GLOBAL, locale);
            for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ITEM)) {
                if (multiplier.skill() != null) continue;
                player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_MULTIPLIER_ADD_ALREADY_EXISTS, locale), "{target}", global));
                return;
            }
            if (lore) {
                skillsItem.addMultiplierLore(ModifierType.ITEM, null, value, locale);
            }
            skillsItem.addMultiplier(ModifierType.ITEM, null, value);
            ItemStack newItem = skillsItem.getItem();
            player.getInventory().setItemInMainHand(newItem);
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_MULTIPLIER_ADD_ADDED, locale), "{target}", global, "{value}", String.valueOf(value)));
        } else {
            throw new InvalidCommandArgument("Target must be valid skill name or global");
        }
    }

    @Subcommand(value="multiplier remove")
    @CommandCompletion(value="@skills_global")
    @CommandPermission(value="auraskills.command.item.multiplier")
    @Description(value="%desc_item_multiplier_remove")
    public void onItemMultiplierRemove(@Flags(value="itemheld") Player player, String target) {
        String targetName;
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        Skill skill = (Skill)this.plugin.getSkillRegistry().getOrNull(NamespacedId.fromDefault(target));
        boolean removed = false;
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ITEM)) {
            if (multiplier.skill() != skill) continue;
            skillsItem.removeMultiplier(ModifierType.ITEM, skill);
            removed = true;
            break;
        }
        item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        if (skill != null) {
            targetName = skill.getDisplayName(locale);
        } else if (target.equalsIgnoreCase("global")) {
            targetName = this.plugin.getMsg(CommandMessage.MULTIPLIER_GLOBAL, locale);
        } else {
            throw new InvalidCommandArgument("Target must be valid skill name or global");
        }
        if (removed) {
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_MULTIPLIER_REMOVE_REMOVED, locale), "{target}", targetName));
        } else {
            player.sendMessage(this.plugin.getPrefix(locale) + TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_MULTIPLIER_REMOVE_DOES_NOT_EXIST, locale), "{target}", targetName));
        }
    }

    @Subcommand(value="multiplier list")
    @CommandPermission(value="auraskills.command.item.multiplier")
    @Description(value="%desc_item_multiplier_list")
    public void onItemMultiplierList(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        StringBuilder message = new StringBuilder(this.plugin.getMsg(CommandMessage.ITEM_MULTIPLIER_LIST_HEADER, locale));
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        for (Multiplier multiplier : skillsItem.getMultipliers(ModifierType.ITEM)) {
            String targetName = multiplier.skill() != null ? multiplier.skill().getDisplayName(locale) : this.plugin.getMsg(CommandMessage.MULTIPLIER_GLOBAL, locale);
            message.append("\n").append(TextUtil.replace(this.plugin.getMsg(CommandMessage.ITEM_MULTIPLIER_LIST_ENTRY, locale), "{target}", targetName, "{value}", String.valueOf(multiplier.value())));
        }
        player.sendMessage(message.toString());
    }

    @Subcommand(value="multiplier removeall")
    @CommandPermission(value="auraskills.command.item.multiplier")
    @Description(value="%desc_item_multiplier_removeall")
    public void onItemMultiplierRemoveAll(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.removeAll(SkillsItem.MetaType.MULTIPLIER, ModifierType.ITEM);
        item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.ITEM_MULTIPLIER_REMOVEALL_REMOVED, locale));
    }

    @Subcommand(value="ignore add")
    @CommandPermission(value="auraskills.command.item.ignore")
    @Description(value="%desc_item_ignore_add")
    public void onItemIgnoreAdd(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.addIgnore();
        item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.ITEM_IGNORE_ADD_ADDED, locale));
    }

    @Subcommand(value="ignore remove")
    @CommandPermission(value="auraskills.command.item.ignore")
    @Description(value="%desc_item_ignore_remove")
    public void onItemIgnoreRemove(@Flags(value="itemheld") Player player) {
        Locale locale = this.plugin.getUser(player).getLocale();
        ItemStack item = player.getInventory().getItemInMainHand();
        SkillsItem skillsItem = new SkillsItem(item, this.plugin);
        skillsItem.removeIgnore();
        item = skillsItem.getItem();
        player.getInventory().setItemInMainHand(item);
        player.sendMessage(this.plugin.getPrefix(locale) + this.plugin.getMsg(CommandMessage.ITEM_IGNORE_REMOVE_REMOVED, locale));
    }
}

