/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.bukkit.api.implementation;

import com.google.common.collect.Sets;
import dev.aurelium.auraskills.api.menu.ContextParser;
import dev.aurelium.auraskills.api.menu.MenuManager;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.bukkit.AuraSkills;
import dev.aurelium.auraskills.bukkit.menus.MenuFileManager;
import dev.aurelium.auraskills.bukkit.menus.util.LevelProgressionOpener;
import dev.aurelium.auraskills.slate.builder.MenuBuilder;
import dev.aurelium.auraskills.slate.context.ContextProvider;
import dev.aurelium.auraskills.slate.function.ItemReplacer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class ApiMenuManager
implements MenuManager {
    private final AuraSkills plugin;
    private final Map<String, List<Consumer<MenuBuilder>>> builders = new ConcurrentHashMap<String, List<Consumer<MenuBuilder>>>();

    public ApiMenuManager(AuraSkills plugin) {
        this.plugin = plugin;
    }

    @Override
    public void buildMenu(String name, Consumer<MenuBuilder> menu) {
        this.builders.computeIfAbsent(name, k -> new ArrayList()).add(menu);
    }

    @Override
    public void openMenu(Player player, String name) {
        this.plugin.getSlate().openMenu(player, name);
    }

    @Override
    public void openMenu(Player player, String name, Map<String, Object> properties) {
        this.plugin.getSlate().openMenu(player, name, properties);
    }

    @Override
    public void openMenu(Player player, String name, Map<String, Object> properties, int page) {
        this.plugin.getSlate().openMenu(player, name, properties, page);
    }

    @Override
    public void openLevelProgressionMenu(Player player, Skill skill) {
        new LevelProgressionOpener(this.plugin).open(player, skill);
    }

    @Override
    public <T> void registerContext(String key, final Class<T> contextClass, final ContextParser<T> parser) {
        this.plugin.getSlate().getContextManager().registerContext(key, new ContextProvider<T>(){

            @Override
            public Class<T> getType() {
                return contextClass;
            }

            @Override
            @Nullable
            public T parse(String menuName, String input) {
                return parser.parse(menuName, input);
            }
        });
    }

    @Override
    public void registerGlobalReplacer(ItemReplacer replacer) {
        this.plugin.getSlate().getGlobalBehavior().globalReplacers().add(replacer);
    }

    public Set<String> getNonDefaultMenuNames() {
        Set nonDefault = Sets.newConcurrentHashSet();
        for (String menuName : this.builders.keySet()) {
            if (Sets.newHashSet((Object[])MenuFileManager.MENU_NAMES).contains(menuName)) continue;
            nonDefault.add(menuName);
        }
        return nonDefault;
    }

    public void applyBuilders(String name, MenuBuilder builder) {
        List<Consumer<MenuBuilder>> consumers = this.builders.get(name);
        if (consumers == null) {
            return;
        }
        for (Consumer<MenuBuilder> consumer : consumers) {
            if (consumer == null) {
                return;
            }
            consumer.accept(builder);
        }
    }
}

