/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.util;

import dev.aurelium.auraskills.api.stat.ReloadableIdentifier;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class AuraSkillsModifier<T extends ReloadableIdentifier> {
    protected final String name;
    protected final T type;
    protected final double value;
    protected final Operation operation;
    private long expirationTime;
    private boolean pauseOffline;
    private boolean nonPersistent;

    public AuraSkillsModifier(String name, T type, double value, @NotNull Operation operation) {
        this.name = name;
        this.type = type;
        this.value = value;
        this.operation = operation;
    }

    public String name() {
        return this.name;
    }

    public T type() {
        return this.type;
    }

    public double value() {
        return this.value;
    }

    public Operation operation() {
        return this.operation;
    }

    public boolean isTemporary() {
        return this.expirationTime != 0L;
    }

    public void makeTemporary(long expirationTime, boolean pauseOffline) {
        this.expirationTime = expirationTime;
        this.pauseOffline = pauseOffline;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isPauseOffline() {
        return this.pauseOffline;
    }

    public boolean isNonPersistent() {
        return this.nonPersistent;
    }

    public void setNonPersistent() {
        this.nonPersistent = true;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuraSkillsModifier that = (AuraSkillsModifier)o;
        return Double.compare(this.value, that.value) == 0 && this.expirationTime == that.expirationTime && this.pauseOffline == that.pauseOffline && this.nonPersistent == that.nonPersistent && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && this.operation == that.operation;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.value, this.operation, this.expirationTime, this.pauseOffline, this.nonPersistent});
    }

    public String toString() {
        return this.name + "," + this.type + "," + this.value;
    }

    public static enum Operation {
        ADD,
        MULTIPLY,
        ADD_PERCENT;


        @NotNull
        public static Operation parse(String name) {
            if (name == null) {
                return ADD;
            }
            try {
                return Operation.valueOf(name.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return ADD;
            }
        }

        public static Operation fromSqlId(byte sqlId) {
            switch (sqlId) {
                case 2: {
                    return MULTIPLY;
                }
                case 3: {
                    return ADD_PERCENT;
                }
            }
            return ADD;
        }

        public byte getSqlId() {
            switch (this) {
                case ADD: {
                    return 1;
                }
                case MULTIPLY: {
                    return 2;
                }
                case ADD_PERCENT: {
                    return 3;
                }
            }
            return 0;
        }

        public String getDisplayName() {
            switch (this) {
                case ADD: {
                    return "Base";
                }
                case MULTIPLY: {
                    return "Multiplicative";
                }
                case ADD_PERCENT: {
                    return "Additive";
                }
            }
            return this.toString();
        }
    }
}

