/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.registry;

import java.util.Locale;
import java.util.Objects;

public class NamespacedId {
    public static final String AURASKILLS = "auraskills";
    private final String namespace;
    private final String originalKey;
    private final String key;

    private NamespacedId(String namespace, String key) {
        this.namespace = namespace.toLowerCase(Locale.ROOT);
        this.originalKey = key;
        this.key = key.toLowerCase(Locale.ROOT);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKey() {
        return this.key;
    }

    public String getSimpleName() {
        if (this.namespace.equals(AURASKILLS)) {
            return this.key;
        }
        return this.toString();
    }

    public String getOriginalKey() {
        return this.originalKey;
    }

    public String toString() {
        return this.namespace + "/" + this.key;
    }

    public static NamespacedId of(String namespace, String key) {
        return new NamespacedId(namespace, key);
    }

    public static NamespacedId fromString(String string) {
        String[] split = string.split("/");
        if (split.length != 2) {
            throw new IllegalArgumentException("Invalid NamespacedId: " + string);
        }
        return new NamespacedId(split[0], split[1]);
    }

    public static NamespacedId fromDefault(String string) {
        String[] split = string.split("/");
        if (split.length == 1) {
            return new NamespacedId(AURASKILLS, split[0]);
        }
        if (split.length != 2) {
            throw new IllegalArgumentException("Invalid NamespacedId: " + string);
        }
        return new NamespacedId(split[0], split[1]);
    }

    public static NamespacedId fromDefaultWithColon(String string) {
        String[] split = string.split("/");
        if (split.length == 1) {
            split = string.split(":");
            if (split.length == 1) {
                return new NamespacedId(AURASKILLS, split[0]);
            }
        } else if (split.length != 2) {
            throw new IllegalArgumentException("Invalid NamespacedId: " + string);
        }
        return new NamespacedId(split[0], split[1]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamespacedId that = (NamespacedId)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.key);
    }
}

