/*
 * Decompiled with CFR 0.152.
 */
package dev.aurelium.auraskills.api.mana;

import dev.aurelium.auraskills.api.annotation.Inject;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.mana.ManaAbilityProvider;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CustomManaAbility
implements ManaAbility {
    @Inject
    private ManaAbilityProvider provider;
    private final NamespacedId id;
    private final Defined defined;

    private CustomManaAbility(NamespacedId id, Defined defined) {
        this.id = id;
        this.defined = defined;
    }

    public static CustomManaAbilityBuilder builder(NamespacedId id) {
        return new CustomManaAbilityBuilder(id);
    }

    public Defined getDefined() {
        return this.defined;
    }

    @NotNull
    public List<String> getInfoFormats() {
        return this.defined.infoFormats;
    }

    @Override
    public Skill getSkill() {
        return this.provider.getSkill(this);
    }

    @Override
    public NamespacedId getId() {
        return this.id;
    }

    @Override
    public int getMaxLevel() {
        return this.provider.getMaxLevel(this);
    }

    @Override
    public int getUnlock() {
        return this.provider.getUnlock(this);
    }

    @Override
    public int getLevelUp() {
        return this.provider.getLevelUp(this);
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.defined.displayName != null ? this.defined.displayName : this.provider.getDisplayName(this, locale, true);
    }

    @Override
    public String getDisplayName(Locale locale, boolean formatted) {
        return this.defined.displayName != null ? this.defined.displayName : this.provider.getDisplayName(this, locale, formatted);
    }

    @Override
    public String getDescription(Locale locale) {
        return this.defined.description != null ? this.defined.description : this.provider.getDescription(this, locale, true);
    }

    @Override
    public String getDescription(Locale locale, boolean formatted) {
        return this.defined.description != null ? this.defined.description : this.provider.getDescription(this, locale, formatted);
    }

    @Override
    public String name() {
        return this.id.getKey().toUpperCase(Locale.ROOT);
    }

    @Override
    public boolean isEnabled() {
        return this.provider.isEnabled(this);
    }

    @Override
    public double getBaseValue() {
        return this.provider.getBaseValue(this);
    }

    @Override
    public double getValuePerLevel() {
        return this.provider.getValuePerLevel(this);
    }

    @Override
    public double getValue(int level) {
        return this.provider.getValue(this, level);
    }

    @Override
    public double getDisplayValue(int level) {
        return this.provider.getDisplayValue(this, level);
    }

    @Override
    public double getBaseCooldown() {
        return this.provider.getBaseCooldown(this);
    }

    @Override
    public double getCooldownPerLevel() {
        return this.provider.getCooldownPerLevel(this);
    }

    @Override
    public double getCooldown(int level) {
        return this.provider.getCooldown(this, level);
    }

    @Override
    public double getBaseManaCost() {
        return this.provider.getBaseManaCost(this);
    }

    @Override
    public double getManaCostPerLevel() {
        return this.provider.getManaCostPerLevel(this);
    }

    @Override
    public double getManaCost(int level) {
        return this.provider.getManaCost(this, level);
    }

    @Override
    public boolean optionBoolean(String key) {
        return this.provider.optionBoolean(this, key);
    }

    @Override
    public boolean optionBoolean(String key, boolean def) {
        return this.provider.optionBoolean(this, key, def);
    }

    @Override
    public int optionInt(String key) {
        return this.provider.optionInt(this, key);
    }

    @Override
    public int optionInt(String key, int def) {
        return this.provider.optionInt(this, key, def);
    }

    @Override
    public double optionDouble(String key) {
        return this.provider.optionDouble(this, key);
    }

    @Override
    public double optionDouble(String key, double def) {
        return this.provider.optionDouble(this, key, def);
    }

    @Override
    public String optionString(String key) {
        return this.provider.optionString(this, key);
    }

    @Override
    public String optionString(String key, String def) {
        return this.provider.optionString(this, key, def);
    }

    @Override
    public List<String> optionStringList(String key) {
        return this.provider.optionStringList(this, key);
    }

    @Override
    public Map<String, Object> optionMap(String key) {
        return this.provider.optionMap(this, key);
    }

    public String toString() {
        return this.id.toString();
    }

    public static class Defined {
        private double baseValue = 10.0;
        private double valuePerLevel = 10.0;
        private double baseCooldown = 200.0;
        private double cooldownPerLevel = -5.0;
        private double baseManaCost = 30.0;
        private double manaCostPerLevel = 5.0;
        private int maxLevel = 0;
        private int unlock = 6;
        private int levelUp = 6;
        private String displayName;
        private String description;
        private List<String> infoFormats = new ArrayList<String>();

        public double getBaseValue() {
            return this.baseValue;
        }

        public void setBaseValue(double baseValue) {
            this.baseValue = baseValue;
        }

        public double getValuePerLevel() {
            return this.valuePerLevel;
        }

        public void setValuePerLevel(double valuePerLevel) {
            this.valuePerLevel = valuePerLevel;
        }

        public double getBaseCooldown() {
            return this.baseCooldown;
        }

        public void setBaseCooldown(double baseCooldown) {
            this.baseCooldown = baseCooldown;
        }

        public double getCooldownPerLevel() {
            return this.cooldownPerLevel;
        }

        public void setCooldownPerLevel(double cooldownPerLevel) {
            this.cooldownPerLevel = cooldownPerLevel;
        }

        public double getBaseManaCost() {
            return this.baseManaCost;
        }

        public void setBaseManaCost(double baseManaCost) {
            this.baseManaCost = baseManaCost;
        }

        public double getManaCostPerLevel() {
            return this.manaCostPerLevel;
        }

        public void setManaCostPerLevel(double manaCostPerLevel) {
            this.manaCostPerLevel = manaCostPerLevel;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public void setMaxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
        }

        public int getUnlock() {
            return this.unlock;
        }

        public void setUnlock(int unlock) {
            this.unlock = unlock;
        }

        public int getLevelUp() {
            return this.levelUp;
        }

        public void setLevelUp(int levelUp) {
            this.levelUp = levelUp;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<String> getInfoFormats() {
            return this.infoFormats;
        }

        public void setInfoFormats(List<String> infoFormats) {
            this.infoFormats = infoFormats;
        }
    }

    public static class CustomManaAbilityBuilder {
        private final NamespacedId id;
        private final Defined defined = new Defined();

        private CustomManaAbilityBuilder(NamespacedId id) {
            this.id = id;
        }

        public CustomManaAbilityBuilder displayName(String displayName) {
            this.defined.setDisplayName(displayName);
            return this;
        }

        public CustomManaAbilityBuilder description(String description) {
            this.defined.setDescription(description);
            return this;
        }

        public CustomManaAbilityBuilder baseValue(double baseValue) {
            this.defined.setBaseValue(baseValue);
            return this;
        }

        public CustomManaAbilityBuilder valuePerLevel(double valuePerLevel) {
            this.defined.setValuePerLevel(valuePerLevel);
            return this;
        }

        public CustomManaAbilityBuilder baseCooldown(double baseCooldown) {
            this.defined.setBaseCooldown(baseCooldown);
            return this;
        }

        public CustomManaAbilityBuilder cooldownPerLevel(double cooldownPerLevel) {
            this.defined.setCooldownPerLevel(cooldownPerLevel);
            return this;
        }

        public CustomManaAbilityBuilder baseManaCost(double baseManaCost) {
            this.defined.setBaseManaCost(baseManaCost);
            return this;
        }

        public CustomManaAbilityBuilder manaCostPerLevel(double manaCostPerLevel) {
            this.defined.setManaCostPerLevel(manaCostPerLevel);
            return this;
        }

        public CustomManaAbilityBuilder maxLevel(int maxLevel) {
            this.defined.setMaxLevel(maxLevel);
            return this;
        }

        public CustomManaAbilityBuilder unlock(int unlock) {
            this.defined.setUnlock(unlock);
            return this;
        }

        public CustomManaAbilityBuilder levelUp(int levelUp) {
            this.defined.setLevelUp(levelUp);
            return this;
        }

        public CustomManaAbilityBuilder infoFormats(List<String> infoFormats) {
            this.defined.setInfoFormats(infoFormats);
            return this;
        }

        public CustomManaAbility build() {
            return new CustomManaAbility(this.id, this.defined);
        }
    }
}

